<script>
    $(document).ready(function () {
        var table = $('.footable').DataTable({

            fixedHeader:true,
            "scrollX": true,
            fixedColumns: true,
            fixedColumns: {
                left: 2
            },
            "processing": true,
            "serverSide": true,
            "ajax": {
                "url": "{{ route('workspace-one-assets-not-created-data') }}",
                "dataType": "json",
                "type": "POST",
                "data": function (result) {
                    result.form = $('#search-form').serializeObject();
                }
            },
            "columns": [
            { "data": "id" },
            { "data": 'serial_no' },
            { "data": 'asset_type_teqtivity' },
            { "data": 'manufacturer_teqtivity' },
            { "data": 'hardware_teqtivity' },
            { "data": 'ownership' },
            { "data": 'location_teqtivity' },
            { "data": 'asset_status_teqtivity' },
            { "data": 'workspaceone_user' },
            { "data": 'teqtivity_user' },
            { "data": 'teqtivity_user_status' },
            { "data": 'teqtivity_user_department' },
            { "data": 'teqtivity_user_work_location' },
            { "data": 'hardware'},
            { "data": 'host_name_workspaceone' },
            { "data": 'mac_address_workspaceone' },
            { "data": 'imei_workspaceone' },
            { "data": 'phone_number' },
            { "data": 'carrier' },
            { "data": 'carrier_country' },
            { "data": 'lock_date' },
            { "data": 'is_locked' },
            { "data": 'last_seen' },
            { "data": "create_asset" },
            ],
            lengthMenu: [
            [50, 100, 200, -1],
            ['50', '100', '200', 'All']
            ],
            columnDefs: [
            { orderable: false, targets: '_all' }
            ],
            "aaSorting": [],
            "dom": '<"top"i>rt<"bottom"flp><"clear">',
            "bAutoWidth": false,
            "bFilter": true,
            "bLengthChange": false,
            "searching": false,
            "fnDrawCallback": function (oSettings) {
                if (table.page.info().recordsTotal == 0) {
                    $("#export-csv").hide();
                } else {
                    $("#export-csv").show();
                }
            },
            "fnInitComplete": function (oSettings, json) {
                $("#DataTables_Table_0_paginate").children().before("<p style='float:left; margin-top: 8px'>Last Sync: {{ $lastSyncDate ?? '' }}</p>")
            }

        });


        //Datatable column toggler
        $('span.col-toggle').on('click', function (e) {
            e.preventDefault();
            $(this).toggleClass('col-hidden');

            // Get the column API object
            var column = table.column($(this).attr('data-column'));
            // Toggle the visibility
            column.visible(!column.visible());

            // // Add class to responsive breakpoint list item
            var columnIndex = column.index();
            var thClassName = column.header().className;
            // console.log(columnIndex);
            $('.dataTables_wrapper').find('li[data-dt-column="'+columnIndex+'"]').addClass(thClassName);
        });

        $('#search-form').submit(function (e) {
            e.preventDefault();
            table.draw();
        });


        $('#export-csv').on('click', function (e) {
            e.preventDefault();
            $('.ajax-loader').show();
            $.ajax({
                type: "POST",
                url: "{{route('devicesNotCreatedExport')}}",
                data: $('#search-form').serializeObject(),
                dataType: 'text',
                success: function (result) {
                    var blob = new Blob([result]);
                    if (window.navigator.msSaveOrOpenBlob)  // IE hack; see http://msdn.microsoft.com/en-us/library/ie/hh779016.aspx
                    window.navigator.msSaveBlob(blob, "workspace-one-checking-in-not-created.csv");
                    else {
                        var a = window.document.createElement("a");
                        a.href = window.URL.createObjectURL(blob, { type: "text/plain" });
                        a.download = "workspace-one-checking-in-not-created.csv";
                        document.body.appendChild(a);
                        a.click();  // IE: "Access is denied"; see: https://connect.microsoft.com/IE/feedback/details/797361/ie-10-treats-blob-url-as-cross-origin-and-denies-access
                        document.body.removeChild(a);
                    }
                    $('.ajax-loader').hide();
                }
            })
        });


        $(document).on("click", ".create-asset", function (e) {
            assetId = $(this).attr('data-asset');
            serial = $(this).attr('data-asset-serial');
            $('.errorText').text('');
            $('.user-select-div').hide();
            $('.location-select-div').hide();
            $('#no_user_location').val(0);
            $('#make_and_model_id').val('').trigger('change').trigger('chosen:updated');
            $('#technical_spec_id').val('').trigger('change').trigger('chosen:updated');
            $('#status_id').val('').trigger('change').trigger('chosen:updated');
            $('#user_id').val('').trigger('chosen:updated');
            $('#location_id').val('').trigger('change');

            $('#create-asset-serial').html(serial);
            $('#create-asset').modal('show');
            $('#workspace-one-asset-id').val(assetId);

        });

        $.ajax({
            type: "POST",
            data: { id: $(this).val(), type: $('#category').val() },
            url: "/assets-create/listHardware",
            success: function (data) {
                $('#make_and_model_id').empty();
                $('#make_and_model_id').append($('<option>', {
                    value: '',
                    text: '---Select---'
                }));
                $.each(data, function (key, value) {
                    $('#make_and_model_id').append($('<option>', {
                        value: value.id,
                        text: value.hardware
                    }));
                });
                $('#make_and_model_id').trigger("chosen:updated");
            },
            error: function (value) {
            }
        });

        $("#make_and_model_id").change(function () {
            if ($(this).val() != '' && $(this).val() != '--Select--' && $(this).val() != '0') {
                try {
                    $.ajax({
                        type: "POST",
                        data: { id: $(this).val() },
                        url: "/assets-create/listtechnics",
                        success: function (data) {
                            $('#technical_spec_id').empty();
                            $('#technical_spec_id').append($('<option>', {
                                value: '',
                                text: '---Select---'
                            }));
                            $.each(data, function (key, value) {
                                $('#technical_spec_id').append($('<option>', {
                                    value: value.id,
                                    text: value.details
                                }));
                            });
                            $('#technical_spec_id').trigger("chosen:updated");
                        },
                        error: function (value) {

                        }
                    });
                } catch (err) {

                }
            }
        });
    });
</script>