<script src="/js/plugins/jquery-validation/jquery.validate.min.js"></script>
<script src="/js/validator-methods.js"></script>
<script src="/js/plugins/chosen/chosen.jquery.js"></script>
<script src="/js/plugins/chosen/chosen.ajaxaddition.jquery.js"></script>

<script>

    $(document).ready(function () {
        $("#create-asset-form").validate({
            ignore: ":hidden:not(select)",
            rules: {
                'make_and_model_id': { required: true },
                'technical_spec_id': { required: true },
                'status_id': { required: true },
            },
            messages: {
                'make_and_model_id': { required: 'Please select a Model' },
                'technical_spec_id': { required: 'Please select a Tech Spec' },
                'status_id': { required: 'Please select a Status' },
            },
            errorPlacement: function (error, element) {
                error.insertAfter($(element).next($('.errorText')));
            },

        });

        // Show corresponding status modal when clicking the submit button.
        $(document).on("click", ".submit-form", function (e) {
            e.preventDefault(); // Prevent default form submission

            const $form = $("#create-asset-form");
            $form.validate(); // ensure validation is initialized

            if ($form.valid()) {
                var statusSlug = $('#status_id').find(":selected").text()
                                .toLowerCase()
                                .replace(/ /g, '-')         // Replace spaces with dashes
                                .replace(/\//g, '-')        // Replace slashes with dashes
                                .replace(/\(|\)/g, '')      // Remove parentheses
                                .replace(/---/g, '-')       // Replace triple dash with single dash
                                .replace(/--/g, '-');       // Replace double dash with single dash

                var data = {
                    'status_id' : $('#status_id').val(),
                    'make_and_model_id' : $('#make_and_model_id').val(),
                    'technical_spec_id' : $('#technical_spec_id').val(),
                    'mdm_create_asset' : '#create-asset-form',
                    'mdm-asset-id' : $('#mdm-asset-id').val(),
                };
    
                // Show the status modal
                var statusModal = $('#' + statusSlug);
                appendExtraDataToModal(data, statusModal);
                statusModal.modal('show');
            }
        });



        // $("#status_id").select2({ dropdownParent: $("#status_id").parent() });


        $('.assigned-user-ajax').each(function () {
            $(this).ajaxChosen({
                dataType: 'json',
            }, {
                processItems: function (data) { return data },
                generateUrl: function (q) { return '/get-filter-fields-assigned-user?search=' + q; },
            },
                {
                    width: "100%"
                }).change(function () {
                    $(this).closest('.form-group').next().find('input').focus();
                });
        });

    });


    //close the existing modal when new one is opened
    $(window).on('shown.bs.modal', function () {
        if ($('.inmodal').hasClass('in')) {
            $('#create-asset').modal('toggle');
        }
    });
</script>