<script src="/js/plugins/chosen/chosen.jquery.js"></script>
<script src="/js/plugins/chosen/chosen.ajaxaddition.jquery.js"></script>
<script src="/js/plugins/select2/select2.full.min.js"></script>
<script src="/js/plugins/dataTables/datatables.min.js"></script>
<script src="/js/plugins/dataTables/dataTables.fixedColumns.min.js"></script>
<link href="/css/plugins/dataTables/fixedHeader.dataTables.min.css" rel="stylesheet">

<script>

  $(document).ready(function () {
    $('.chosen-select').chosen({ width: "100%" }).change(function () {
      $(this).closest('.form-group').next().find('input').focus();
    });

    $.fn.serializeObject = function () {
      var obj = {};

      $.each(this.serializeArray(), function (i, o) {
        var n = o.name, v = o.value;

        obj[n] = obj[n] === undefined ? v
          : $.isArray(obj[n]) ? obj[n].concat(v)
            : [obj[n], v];
      });

      return obj;
    };


    var delay = (function () {
      var timer = 0;
      return function (callback, ms) {
        clearTimeout(timer);
        timer = setTimeout(callback, ms);
      };
    })();

    $(".report-filter").on('change', function () {
      $('#search-form').submit();
    });

    $('.filter-datepicker').on('show', function (e) {
      $("th.clear").attr('colspan', 8)
    }).datepicker({
      todayBtn: "linked",
      clearBtn: true,
      keyboardNavigation: false,
      forceParse: false,
      calendarWeeks: false,
      autoclose: true,
    }).on('changeDate', function (e) {
      $('#search-form').submit();
    });

    $(".filter-field").each(function () {
      var name = $(this).attr('key');
      $(this).select2({
        minimumInputLength: 1,
        multiple: true,
        ajax: {
          url: '/get-filter-fields',
          dataType: "json",
          data: function (params) {
            var query = {
              search: params.term,
              type: name
            }

            // Query parameters will be ?search=[term]&type=public
            return query;
          },
          processResults: function (data) {
            // Tranforms the top-level key of the response object from 'items' to 'results'
            return {
              results: data
            };
          },

        }
      });
    });

    $(".filter-field-user").each(function () {
      $(this).select2({
        minimumInputLength: 1,
        multiple: true,
        ajax: {
          url: '/get-filter-fields-all-user',
          dataType: "json",
          data: function (params) {
            var query = {
              search: params.term
            }

            // Query parameters will be ?search=[term]&type=public
            return query;
          },
          processResults: function (data) {
            // Tranforms the top-level key of the response object from 'items' to 'results'
            return {
              results: data
            };
          },

        }
      });
    });

    $(".filter-field-mobile-iron").each(function () {
      var name = $(this).attr('key');
      $(this).select2({
        minimumInputLength: 1,
        multiple: true,
        ajax: {
          url: '/discovery-tools/mobileiron/get-filter-fields-mobile-iron',
          dataType: "json",
          data: function (params) {
            var query = {
              search: params.term,
              type: name
            }

            // Query parameters will be ?search=[term]&type=public
            return query;
          },
          processResults: function (data) {
            // Tranforms the top-level key of the response object from 'items' to 'results'
            return {
              results: data
            };
          },

        }
      });
    });



    $(".filter-field-location").each(function () {
      var name = $(this).attr('key');
      $(this).select2({
        minimumInputLength: 1,
        multiple: true,
        ajax: {
          url: '/get-filter-fields-location',
          dataType: "json",
          data: function (params) {
            var query = {
              search: params.term,
              type: name,
            }

            // Query parameters will be ?search=[term]&type=public
            return query;
          },
          processResults: function (data) {
            // Tranforms the top-level key of the response object from 'items' to 'results'
            return {
              results: data
            };
          },

        }
      });
    });

    $('.assigned-user-ajax').each(function () {
      $(this).ajaxChosen({
        dataType: 'json',
      }, {
        processItems: function (data) { return data },
        generateUrl: function (q) { return '/get-filter-fields-assigned-user?search=' + q; },
      },
        {
          width: "100%"
        }).change(function () {
          $(this).closest('.form-group').next().find('input').focus();
        });
    });
    

    $(".filter-field-user-department").each(function() {
        var name = $(this).attr('key');
        $( this ).select2({
            minimumInputLength: 1,
            multiple: true,
            ajax: {
                url: '/get-filter-fields-user-department',
                dataType: "json",
                data: function (params){
                  var query = {
                    search: params.term
                  }

                  // Query parameters will be ?search=[term]&type=public
                  return query;
                },
                processResults: function (data) {
                  // Tranforms the top-level key of the response object from 'items' to 'results'
                  return {
                    results: data
                  };
                },

            }
        });
  });
})
</script>