<script>
$(document).ready(function() {
    //Update Asset Section
    $(document).on("click", ".update-discrepancy-asset", function(e) {
        assetId         = $(this).attr('data-asset');
        serial          = $(this).attr('data-asset-serial');
        currentStatus   = $(this).attr('data-asset-current-status');
        parentAsset     = $(this).attr('parent_asset_id');

        $('#update-user-discrepancy-asset-serial').html(serial);
        $('#update-user-discrepancy-asset').modal('show');

        $('#available-status-list').attr('data-id', assetId);
        $('#available-status-list').attr('data-parent', parentAsset);
        $('#update_assignee').find('#asset_id').val(assetId);
        
        //List the proper statuses for the status update
        $.ajax({  
            type: "GET", 
            data:{status:currentStatus, id:assetId},
            url: "/list-asset-statuses",  
            success: function(data) { 
                $('#available-status-list').empty();
                $('#available-status-list').append($('<option>', {
                      value: null,
                      text: "--Select--"
                     }));
                $.each(data,function (key,value) {
                    if (value) {
                        $('#available-status-list').append($('<option>', {
                            value: value.id,
                            text:  value.name 
                        }));
                    }
                });
                $("#available-status-list").chosen({width: "100%"});
            },
            error: function(value) { 
            }
        });

    });

    //Update Asset Option Selection
    $('input[name="discrepancy-asset-action"]').on('click', function(e) {
        selected = $('input[name="discrepancy-asset-action"]:checked').val();
        if (selected == 'status_update') {
            $('#asset-status-list').show();
        }

        if (selected == 'update_assignee') {
            $('#asset-status-list').hide();
            $('#'+selected ).modal('show');
        }
    });

    //update assignee form submit
    $("#assignee-update-submit").on('click', function() {
        $('#update-assignee-form-form').submit();
    });

    //close the existing modal when new one is opened
    $(window).on('shown.bs.modal', function() { 
        if ($('.inmodal').hasClass('in')) {
            $('#update-user-discrepancy-asset').modal('toggle');
        }
    });

    $("#update-assignee-form-form").validate({
        onkeyup: false,
        excluded: ':disabled',
    });
});
</script>