@extends('layouts.main')
@section('content')

@include('partials.breadcrumb', ['breadcrumbTitle' => 'Not Checking In - Not Managed & Deployed', 'parentUrl' => '#', 'parentTitle' => 'Discovery Tools', 'parentSubUrl' => '#', 'parentSubTitle' =>
'JumpCloud'])
@include('discovery-tools.jumpcloud.submenu')

<div class="wrapper-content">
    <div class="container-fluid">
        <div class="row">
            @include('discovery-tools.jumpcloud.partials.not-checking-in-not-managed-filter')
        </div>
        <div class="row">
            <div class="col-lg-12">
                <div class="ibox">
                    <div class="ibox-title">
                        @include('discovery-tools.jumpcloud.partials.jumpcloud-common-table-top',['route'=>'jumpcloud-not-checking-in-not-managed-export','fileName'=>'jumpcloud-not-checking-in-not-managed-report'])
                    </div>
                    <div class="ibox-content">
                        @include('partials.success')
                        @include('partials.error-message')
                        <div class="ajax-loader" ><img src="/img/ajax-loader-full-width.gif"></div>

                        @include('discovery-tools.jumpcloud.partials.jumpcloud-common-togglers')
                        
                        <table class="footable table table-stripped table-hover nowrap two-col-fixed has-column-toggler" data-page-size="50" 
                        data-role="ui-data-table" data-url="{{ route('jumpcloud-not-checking-in-not-managed-data') }}" data-searching="false" data-ordering="false" data-page-size="50" data-fixed-header="true"
                        data-filter=#filter>

                            <thead>

                                <tr>

                                    <th class="th-teq" data-col-name="id">#</th>
                                    <th class="th-teq" data-col-name="serial_no">Serial #</th>
                                    <th class="th-teq" data-col-name="asset_type">Asset Type</th>
                                    <th class="th-teq" data-col-name="manufacturer_teq">Manufacturer</th>
                                    <th class="th-teq" data-col-name="hardware_teq">Hardware Standard</th>

                                    <th class="th-teq" data-col-name="location_teq">Asset Location</th>
                                    <th class="th-teq" data-col-name="asset_status_teq">Asset Status</th>

                                    <th class="th-teq" data-col-name="teq_user">User</th>
                                    <th class="th-teq" data-col-name="teq_user_status">User Status</th>
                                    <th class="th-teq" data-col-name="teq_user_department">User Department</th>
                                    <th class="th-teq" data-col-name="teq_user_work_location">User Work Location</th>

                                    <th class="th-teq" data-col-name="host_name_teqtivity">Host Name</th>
                                    <th class="th-teq" data-col-name="mac_address_teqtivity">MAC Address</th>
                                    <th class="th-teq" data-col-name="imei_teqtivity">IMEI</th>
                                    <th class="th-teq" data-col-name="carrier">Carrier</th>
                                    <th class="th-teq" data-col-name="carrier_country">Carrier Country</th>
                                    <th class="th-teq" data-col-name="last_modified_date">Last Seen Date</th>

                                </tr>

                            </thead>

                            <tbody>

                            </tbody>

                        </table>

                        

                    </div>

                </div>

            </div>

        </div>

    </div>

</div>
@stop

@section('after_scripts')

@include('discovery-tools.jumpcloud.scripts.jumpcloud-common-script')
@include('reports.scripts.datatable')
@include('reports.scripts.datatable-column-toggle-script')

@stop