@extends('layouts.main')
@section('content')

@include('partials.breadcrumb', ['breadcrumbTitle' => 'Not Checking In - Managed & Deployed', 'parentUrl' => '#', 'parentTitle' => 'Discovery Tools', 'parentSubUrl' => '#', 'parentSubTitle' =>
'JumpCloud'])
@include('discovery-tools.jumpcloud.submenu')

@php $editPermission = config('permission.edit_permissions.it_assets_edit'); @endphp
<div class="wrapper-content">
    <div class="container-fluid">
        <div class="row">
            @include('discovery-tools.jumpcloud.partials.common-jumpcloud-filter')

        </div>
        <div class="row">
            <div class="col-lg-12">
                <div class="ibox">
                    <div class="ibox-title">
                        @include('discovery-tools.jumpcloud.partials.jumpcloud-common-table-top',['route'=>'jumpcloud-not-checking-in-managed-export','fileName'=>'jumpcloud-not-checking-in-managed-report'])
                    </div>
                    <div class="ibox-content">
                        @include('partials.success')
                        @include('partials.error-message')
                        <div class="ajax-loader" ><img src="/img/ajax-loader-full-width.gif"></div>
                        @include('discovery-tools.jumpcloud.partials.jumpcloud-common-togglers')

                        
                        <table class="footable table table-stripped table-hover nowrap two-col-fixed has-column-toggler" data-page-size="50" 
                        data-role="ui-data-table" data-url="{{ route('jumpcloud-not-checking-in-managed-data') }}" data-searching="false" data-ordering="false" data-page-size="50" data-fixed-header="true"
                        data-filter=#filter>

                            <thead>
                                <tr>
                                    @include('discovery-tools.jumpcloud.partials.jumpcloud-common-theads')
                                    <th class="th-mdm" data-col-name="update_asset">Update Asset</th>
                                </tr>
                            </thead>
                            <tbody>
                            </tbody>
                        </table>
                        
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@include('discovery-tools.modals.update-discovery-asset')
@stop

@section('after_scripts')

@include('discovery-tools.jumpcloud.scripts.jumpcloud-common-script')
@include('reports.scripts.datatable')
@include('reports.scripts.datatable-column-toggle-script')
@include('assets.partials.scripts.dropdown-script')
@include('discovery-tools.scripts.update-discovery-asset')
@include('assets.partials.scripts.search')

@stop