<script>
  $(document).ready(function () {
    var table = $('.footable').DataTable({
      fixedHeader:true,
      "scrollX": true,
      scrollY: '400px',
            scrollCollapse: true,
      fixedColumns: true,
      fixedColumns: {
        left: 2
      },
      "processing": true,
      "serverSide": true,
      "ajax": {
        "url": "{{ route('chrome-devices-not-checking-in-managed') }}",
        "dataType": "json",
        "type": "POST",
        "data": function (result) {
          result.form = $('#search-form').serializeObject();
        }
      },
      "columns": [
      { "data":'id'},
      { "data":'serial_no'},
      { "data":'asset_type'},
      { "data":'manufacturer_teqtivity'},
      { "data":'hardware_teqtivity'},
      { "data":'location_teqtivity'},
      { "data":'asset_status_teqtivity'},
      { "data":'chromebook_user'},
      { "data":'teqtivity_user'},
      { "data":'teqtivity_user_status'},
      { "data":'teqtivity_user_department'},
      { "data":'teqtivity_user_work_location'},
      { "data":'hardware_chromebook'},
      { "data":'host_name_chromebook'},
      { "data":'mac_address_chromebook'},
      { "data":'last_sync'},
      { "data": "update_asset" },
      ],
      lengthMenu: [
      [50, 100, 200, -1],
      ['50', '100', '200', 'All']
      ],
      columnDefs: [
      { orderable: false, targets: '_all' }
      ],
      "aaSorting": [],
      "dom": '<"top"i>rt<"bottom"flp><"clear">',
      "bAutoWidth": false,
      "bFilter": true,
      "bLengthChange": false,
      "searching": false,
      "fnDrawCallback": function (oSettings) {
        if (table.page.info().recordsTotal == 0) {
          $("#export-csv").hide();
        } else {
          $("#export-csv").show();
        }
      },
      "fnInitComplete": function (oSettings, json) {
        $("#DataTables_Table_0_paginate").children().before("<p style='float:left; margin-top: 8px'>Last Sync: {{ $lastSyncDate ?? '' }}</p>")
      }
    });

    //Datatable column toggler
    $('span.col-toggle').on('click', function (e) {
      e.preventDefault();
      $(this).toggleClass('col-hidden');
      // Get the column API object
      var column = table.column($(this).attr('data-column'));

      // Toggle the visibility
      column.visible(!column.visible());
      // // Add class to responsive breakpoint list item
      var columnIndex = column.index();
      var thClassName = column.header().className;
      // console.log(columnIndex);
      $('.dataTables_wrapper').find('li[data-dt-column="'+columnIndex+'"]').addClass(thClassName);
    });

    $('#search-form').submit(function (e) {
      e.preventDefault();
      table.draw();
    });

    $('#export-csv').on('click', function (e) {
      e.preventDefault();
      $('.ajax-loader').show();
      $.ajax({
        type: "POST",
        url: "{{route('chrome-devices-not-checking-in-managed-export')}}",
        data: $('#search-form').serializeObject(),
        dataType: 'text',
        success: function (result) {
          var blob = new Blob([result]);
          if (window.navigator.msSaveOrOpenBlob)  // IE hack; see http://msdn.microsoft.com/en-us/library/ie/hh779016.aspx
          window.navigator.msSaveBlob(blob, "chrome-devices-not-checking-in-managed.csv");
          else {
            var a = window.document.createElement("a");
            a.href = window.URL.createObjectURL(blob, { type: "text/plain" });
            a.download = "chrome-devices-not-checking-in-managed.csv";
            document.body.appendChild(a);
            a.click();  // IE: "Access is denied"; see: https://connect.microsoft.com/IE/feedback/details/797361/ie-10-treats-blob-url-as-cross-origin-and-denies-access
            document.body.removeChild(a);
          }
          $('.ajax-loader').hide();
        }
      })
    });

  });
</script>