@extends('layouts.main')
@section('content')
@include('partials.breadcrumb', ['breadcrumbTitle' => 'Inventory Dashboard'])
@include('dashboard.submenu')
<div class="wrapper-content">
    <div class="container-fluid inventory-dashboard">
        
        <h3>System Assets</h3>
        <hr>
        <div class="row">
            <div class="col-md-3">
                <div class="ibox">
                    <div class="ibox-content justify-space-between">
                        Total System Assets
                        <a target="_blank" href="report/generator" class="stretched-link h4">{{$count['total_assets']}}</a>
                    </div>
                </div>
            </div>
            @foreach($assetStatuses as $statusKey => $statusData)
            <div class="col-md-3">
                <div class="ibox">
                    <div class="ibox-content justify-space-between">
                        {{$statusData->name}}
                        <a target="_blank" href="report/generator?status={{$statusData->slug}}" class="stretched-link h4">{{$count[$statusData->slug]}}</a>
                    </div>
                </div>
            </div>
            @endforeach
        </div>
        
        <h3>Asset Inventory</h3>
        <hr>
        <div class="row">
            @foreach($computersWidgetData as $statusName => $computersWidgetData)
            <div class="col-md-4">
                <div class="ibox">
                    <div class="ibox-title"><h5>{{$statusName}}  ({{array_sum($computersWidgetData)}})</h5></div>
                    <div class="ibox-content match-height-block">
                        <table class="table table-stripped table-hover">
                            <tbody>
                                <tr>
                                    <td>Mac</td>
                                    <td><a target="_blank" href={!! "inventory-control/in-stock-computers?status=" . $computersWidgetData['slug'] ."&type=mac" !!} class="font-bold">{{$computersWidgetData['mac_assets']}}</a></td>
                                </tr>
                                <tr>
                                    <td>PC</td>
                                    <td><a target="_blank" href={!! "inventory-control/in-stock-computers?status=". $computersWidgetData['slug'] ."&type=pc" !!} class="font-bold">{{$computersWidgetData['pc_assets']}}</a></td>
                                </tr>
                            </tbody>                            
                        </table>
                    </div>
                </div>
            </div>
            @endforeach
        </div>
        <div class="row">
            <div class="col-lg-4">
                <div class="ibox">
                    <div class="ibox-title">
                        <h5>Total System Assets</h5>
                    </div>
                    <div class="ibox-content">
                        <div id="morris-one-line-chart"></div>
                    </div>
                </div>
            </div>
            <div class="col-lg-4">
                <div class="ibox">
                    <div class="ibox-title"><h5>Assets Brand New, Used by Region</h5></div>
                    <div class="ibox-content">
                        <table class="table table-stripped table-hover">
                            <thead>
                                <tr>
                                    <th>Region</th>
                                    <th>Asset Total ({{$count['used_new_asset']}})</th>
                                </tr>
                            </thead>
                            <tbody>
                                @if(!empty($regionCount))
                                @foreach($regionCount as $region)
                                <tr>
                                    <td>{{$region['name']}}</td>
                                    <td>
                                        @if($region['count'] > 0)
                                        <a target="_blank" href="report/generator?status=usedandnew&type={{$region['id']}}">{{$region['count']}}</a>
                                        @else {{$region['count']}}
                                        @endif
                                    </td>
                                </tr>
                                @endforeach
                                @endif
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
            <div class="col-lg-4">
                <div class="ibox">
                    <div class="ibox-title"><h5>Total System Assets by Type</h5></div>
                    <div class="ibox-content">
                        <table class="table table-stripped table-hover">
                            <thead>
                                <tr>
                                    <th>Asset Type</th>
                                    <th>Asset Total ({{$count['total_assets']}})</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($assetTypes as $assetType)
                                <tr>
                                    <td>{{$assetType->name}}</td>
                                    <td><a target="_blank" href="report/generator?status=asset_type&type={{$assetType->slug}}">{{$assetType->assets_count}}</a></td>
                                </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
        
        <div class="row">
            <div class="col-md-3">
                <div class="ibox">
                    <div class="ibox-content justify-space-between">
                        Assets Assigned to Inactive Users
                        <a target="_blank" href="report/generator?status=inactive_users" class="stretched-link h4">{{$count['inactivePersons']}}</a>
                    </div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="ibox">
                    <div class="ibox-content justify-space-between">
                        Assets Assigned to Inactive Location
                        <a target="_blank" href="report/generator?status=inactive_locations" class="stretched-link h4">{{$count['inactiveLocations']}}</a>
                    </div>
                </div>
            </div>
            
            <div class="col-md-3">
                <div class="ibox">
                    <div class="ibox-content justify-space-between">
                        Assets Over 4 Years
                        <a target="_blank" href="report/generator?status=ageover_fouryears" class="stretched-link h4">{{$count['ageOverFourYears']}}</a>
                    </div>
                </div>
            </div>
            
            <div class="col-md-3">
                <div class="ibox">
                    <div class="ibox-content justify-space-between">
                        Damaged Over 30 Days
                        <a target="_blank" href="report/generator?status=damagedover_thirtydays" class="stretched-link h4">{{$count['damagedOverThirtyDays']}}</a>
                    </div>
                </div>
            </div> 
        </div>
        <div class="row">        
            <div class="col-lg-4">
                <div class="ibox">
                    <div class="ibox-title"><h5>Loaners</h5></div>
                    <div class="ibox-content match-height-block">
                        <table class="table table-stripped table-hover">
                            <tbody>
                                <tr>
                                    <th>Due this week </th>
                                    <th><a target="_blank" href="report/generator?status=loaned&type=due_this_week">{{$count['loaner_due_week']}}</a></th>
                                </tr>
                                <tr>
                                    <th>Past Due </th>
                                    <th><a target="_blank" href="report/generator?status=loaned&type=past_due">{{$count['loaner_past_due']}}</a></th>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
            
            <div class="col-lg-4">
                <div class="ibox">
                    <div class="ibox-title"><h5>Retention</h5></div>
                    <div class="ibox-content match-height-block">
                        <table class="table table-stripped table-hover">
                            <tbody>
                                <tr>
                                    <th>Due this week </th>
                                    <th><a target="_blank" href="report/generator?status=retain_hold&type=due_this_week">{{$count['retention_due_week']}}</a></th>
                                </tr>
                                <tr>
                                    <th>Past Due </th>
                                    <th><a target="_blank" href="report/generator?status=retain_hold&type=past_due">{{$count['retention_past_due']}}</a></th>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>       
            <div class="col-lg-4">
                <div class="ibox">
                    <div class="ibox-title"><h5>Lease</h5></div>
                    <div class="ibox-content">
                        <table class="table table-stripped table-hover">
                            <tbody>
                                <tr>
                                    <th>Due this week </th>
                                    <th><a target="_blank" href="report/generator?status=lease&type=due_this_week">{{$count['lease_due_week']}}</a></th>
                                </tr>
                                <tr>
                                    <th>Past Due </th>
                                    <th><a target="_blank" href="report/generator?status=lease&type=past_due">{{$count['lease_past_due']}}</a></th>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
        
        
        <h3>Asset Health</h3>
        <hr>
        
        <div class="row">
            <div class="col-md-3">
                <div class="ibox">
                    <div class="ibox-content justify-space-between">
                        Assigned assets missing user
                        <a target="_blank" href="report/generator?status=assigned_missinguser" class="stretched-link h4">{{$assetHealthCount['assigned_assets_missing_user']}}</a>
                    </div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="ibox">
                    <div class="ibox-content justify-space-between">
                        Missing tech specs
                        <a target="_blank" href="report/generator?status=missingtechspec" class="stretched-link h4">{{$assetHealthCount['missing_tech_specs']}}</a>
                    </div>
                </div>
            </div>
            
            <div class="col-md-3">
                <div class="ibox">
                    <div class="ibox-content justify-space-between">
                        Missing PO #
                        <a target="_blank" href="report/generator?status=missing_po" class="stretched-link h4">{{$assetHealthCount['missing_po']}}</a>
                    </div>
                </div>
            </div>
            
            <div class="col-md-3">
                <div class="ibox">
                    <div class="ibox-content justify-space-between">
                        Missing Vendor
                        <a target="_blank" href="report/generator?status=missing_vendor" class="stretched-link h4">{{$assetHealthCount['missing_vendor']}}</a>
                    </div>
                </div>
            </div>
        </div>
        
        <div class="row">
            <div class="col-md-3">
                <div class="ibox">
                    <div class="ibox-content justify-space-between">
                        Outdated OS version
                        <a target="_blank" href="/report/os-compliance-report/apple" class="stretched-link h4">{{$assetHealthCount['outdated_os_version']}}</a>
                    </div>
                </div>
            </div>
            
            <div class="col-md-3">
                <div class="ibox">
                    <div class="ibox-content justify-space-between">
                        Expired Warranty Dates
                        <a target="_blank" href="report/generator?status=warranty_expired" class="stretched-link h4">{{$assetHealthCount['expired_warranty_date']}}</a>
                    </div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="ibox">
                    <div class="ibox-content justify-space-between">
                        Duplicated Serial #
                        <a target="_blank" href="report/duplicate-assets" class="stretched-link h4">{{$assetHealthCount['duplicate_serial_no']}}</a>
                    </div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="ibox">
                    <div class="ibox-content justify-space-between">
                        Duplicated Asset Tags
                        <a target="_blank" href="report/duplicate-assets?duplicated_field=asset_tag" class="stretched-link h4">{{$assetHealthCount['duplicate_tag']}}</a>
                    </div>
                </div>
            </div>
        </div>
    </div>
    @stop
    
    @section('help-links')
    @include('help.help-links',['helpLink'=>config('help-links.help_links.inventory_dashboard'),'helpTitle'=>config('help-links.help_titles.inventory_dashboard')])
    @endsection
    
    @section('after_scripts')
    
    <!-- Morris -->
    <script src="js/plugins/morris/raphael-2.1.0.min.js"></script>
    <script src="js/plugins/morris/morris.min.js"></script>
    <script src="/js/plugins/match-height/jquery.matchHeight.min.js"></script>
    <script>
        $(function() {
            $('.match-height-block').matchHeight({ property: 'height' });
            var months = {!! json_encode($monthNames) !!};
            Morris.Line({
                element: 'morris-one-line-chart',
                data: {!! json_encode($assetLineGraphData) !!},
                xkey: 'month',
                ykeys: ['asset'],
                labels: ['Assets'],
                xLabelAngle: 60,
                resize : true,
                smooth : false,
                xLabelFormat: function(x) {
                    var month = months[x.getMonth()];
                    return month;
                },
                dateFormat: function(x) {
                    var month = months[new Date(x).getMonth()];
                    return month;
                },
            });
        });
    </script>
    @stop