@extends('layouts.main')
@section('content')
@include('partials.breadcrumb', ['breadcrumbTitle' => 'Dashboard'])
@include('dashboard.submenu') 
<div class="wrapper-content">
    <div class="container-fluid">
        
        <div class="row">
            <div class="col-md-3">
                <div class="ibox">
                    <div class="ibox-content justify-space-between">
                        Total System Assets
                        <a target="_blank" href="report/generator" class="stretched-link h4">{{$count['total_assets']}}</a>
                    </div>
                </div>
            </div>
            @foreach ($assetStatuses as $assetStatus)
            <div class="col-md-3">
                <div class="ibox">
                    <div class="ibox-content justify-space-between">
                        {{$assetStatus->name}}
                        <a class="stretched-link h4" target="_blank"
                        href="report/generator?status={{$assetStatus->slug}}">{{$assetStatus->assets_count}}</a>
                    </div>
                </div>
            </div>
            @endforeach
        </div>
        
        
        
        <div class="row">
            @foreach($computersWidgetData as $statusName => $computersWidgetData)
            <div class="col-md-4">
                <div class="ibox">
                    <div class="ibox-title">
                        <h5>{{$statusName}} ({{array_sum($computersWidgetData)}})</h5>
                    </div>
                    <div class="ibox-content  match-height-block">
                        <table class="table table-stripped table-hover">
                            <tbody>
                                <tr>
                                    <td>Mac</td>
                                    <td><a target="_blank"
                                        href={!! "inventory-control/in-stock-computers?status=" . $computersWidgetData['slug'] ."&amp;type=mac_computers" !!}
                                        class="font-bold">{{$computersWidgetData['mac_assets']}}</a></td>
                                    </tr>
                                    <tr>
                                        <td>PC</td>
                                        <td><a target="_blank"
                                            href={!! "inventory-control/in-stock-computers?status=" . $computersWidgetData['slug'] . "&amp;type=pc" !!}
                                            class="font-bold">{{$computersWidgetData['pc_assets']}}</a></td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                    @endforeach
                </div>
                
                <div class="row">
                    <div class="col-lg-4">
                        <div class="ibox">
                            <div class="ibox-title">
                                <h5>Total System Assets</h5>
                            </div>
                            <div class="ibox-content">
                                <div id="morris-one-line-chart"></div>
                                
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-4">
                        <div class="ibox">
                            <div class="ibox-title">
                                <h5>Assets by Status</h5>
                            </div>
                            <div class="ibox-content">
                                <div id="morris-donut-chart"></div>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-4">
                        <div class="ibox">
                            <div class="ibox-title">
                                <h5>Assets Assigned, Installed, Loaned</h5>
                            </div>
                            <div class="ibox-content">
                                <div id="morris-donut-chart2"></div>
                            </div>
                        </div>
                    </div>
                </div>
                
                <div class="row">
                    <div class="col-lg-4">
                        <div class="ibox">
                            <div class="ibox-title">
                                <h5>Assets Brand New, Used, Used Loaner</h5>
                            </div>
                            <div class="ibox-content">
                                <table class="footable table table-stripped table-hover">
                                    <thead>
                                        <tr>
                                            <th>Region</th>
                                            <th>Asset Total ({{$count['used_new_asset']}})</th>
                                        </tr>
                                        
                                    </thead>
                                    
                                    <tbody>
                                        @if(!empty($regionCount))
                                        @foreach($regionCount as $region)
                                        <tr>
                                            <td>{{$region['name']}}</td>
                                            <td>
                                                @if($region['count'] > 0)
                                                <a target="_blank"
                                                href="report/generator?status=usedandnew&type={{$region['id']}}">{{$region['count']}}</a>
                                                @else {{$region['count']}}
                                                @endif
                                            </td>
                                        </tr>
                                        @endforeach
                                        @endif
                                    </tbody>
                                    
                                </table>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-4">
                        <div class="ibox">
                            <div class="ibox-title">
                                <h5>Total System Assets by Type</h5>
                            </div>
                            <div class="ibox-content">
                                <table class="footable table table-stripped table-hover">
                                    <thead>
                                        <tr>
                                            <th>Asset Type</th>
                                            <th>Asset Total ({{$count['total_assets']}})</th>
                                        </tr>
                                        
                                    </thead>
                                    
                                    <tbody>
                                        @foreach($assetTypes as $assetType)
                                        <tr>
                                            <td>{{$assetType->name}}</td>
                                            <td><a target="_blank"
                                                href="report/generator?status=asset_type&type={{$assetType->slug}}">{{$assetType->assets_count}}</a>
                                            </td>
                                        </tr>
                                        @endforeach
                                        
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-4">
                        <div class="ibox">
                            <div class="ibox-title">
                                <h5>Total System Asset by Status</h5>
                            </div>
                            <div class="ibox-content">
                                <table class="footable table table-stripped table-hover">
                                    <thead>
                                        <tr>
                                            <th>Asset Status</th>
                                            <th>Asset Total ({{$count['total_assets']}})</th>
                                        </tr>
                                        
                                    </thead>
                                    
                                    <tbody>
                                        @foreach($assetStatuses as $assetStatus)
                                        <tr>
                                            <td>{{$assetStatus->name}}</td>
                                            <td><a target="_blank"
                                                href="report/generator?status={{$assetStatus->slug}}">{{$assetStatus->assets_count}}</a>
                                            </td>
                                        </tr>
                                        @endforeach
                                        
                                    </tbody>
                                    
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
                
                <div class="row">
                    <div class="col-md-4">
                        <div class="ibox">
                            <div class="ibox-content justify-space-between">
                                Assets Assigned to Inactive Users
                                <a target="_blank" href="report/generator?status=inactive_users" class="stretched-link h4">{{$count['inactivePersons']}}</a>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="ibox">
                            <div class="ibox-content justify-space-between">
                                Assets Assigned to Inactive Location
                                <a target="_blank" href="report/generator?status=inactive_locations" class="stretched-link h4">{{$count['inactiveLocations']}}</a>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="ibox">
                            <div class="ibox-content justify-space-between">
                                Assets Over 4 Years
                                <a target="_blank" href="report/generator?status=ageover_fouryears" class="stretched-link h4">{{$count['ageOverFourYears']}}</a>
                            </div>
                        </div>
                    </div>                
                    
                    <div class="col-md-4">
                        <div class="ibox">
                            <div class="ibox-content justify-space-between">
                                Damaged Over 30 Days
                                <a target="_blank" href="report/generator?status=damagedover_thirtydays" class="stretched-link h4">{{$count['damagedOverThirtyDays']}}</a>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="ibox">
                            <div class="ibox-content justify-space-between">
                                Lost and Stolen Assets without Data Wipe
                                <a target="_blank" href="report/generator?status=stolen_lost&type=without_data_wipe" class="stretched-link h4">{{$count['lost_stolen_asset']}}</a>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="ibox">
                            <div class="ibox-content justify-space-between">
                                End of Life Disposed assets without Data Certificates
                                <a target="_blank" href="report/generator?status=end_of_life_data_wiped&type=without_certificate" class="stretched-link h4">{{$count['end_of_life_asset']}}</a>
                            </div>
                        </div>
                    </div>
                </div>
                
                <div class="row">
                    <div class="col-lg-4">
                        <div class="ibox">
                            <div class="ibox-title">
                                <h5>Loaners</h5>
                            </div>
                            <div class="ibox-content">
                                <table class="table table-stripped table-hover">
                                    
                                    <tbody>
                                        <tr>
                                            <th>Due this week </th>
                                            <th><a target="_blank"
                                                href="report/generator?status=loaned&type=due_this_week">{{$count['loaner_due_week']}}</a>
                                            </th>
                                        </tr>
                                        
                                        <tr>
                                            <th>Past Due </th>
                                            <th><a target="_blank"
                                                href="report/generator?status=loaned&type=past_due">{{$count['loaner_past_due']}}</a>
                                            </th>
                                        </tr>
                                        
                                    </tbody>
                                    
                                </table>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-4">
                        <div class="ibox">
                            <div class="ibox-title">
                                <h5>Retain Hold</h5>
                            </div>
                            <div class="ibox-content">
                                <table class="table table-stripped table-hover">
                                    
                                    <tbody>
                                        <tr>
                                            <th>Due this week </th>
                                            <th><a target="_blank"
                                                href="report/generator?status=retain_hold&type=due_this_week">{{$count['retention_due_week']}}</a>
                                            </th>
                                        </tr>
                                        
                                        <tr>
                                            <th>Past Due </th>
                                            <th><a target="_blank"
                                                href="report/generator?status=retain_hold&type=past_due">{{$count['retention_past_due']}}</a>
                                            </th>
                                        </tr>
                                        
                                    </tbody>
                                    
                                </table>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-4">
                        <div class="ibox">
                            <div class="ibox-title">
                                <h5>Lease</h5>
                            </div>
                            <div class="ibox-content">
                                <table class="table table-stripped table-hover">
                                    
                                    <tbody>
                                        <tr>
                                            <th>Due this week </th>
                                            <th><a target="_blank"
                                                href="report/generator?status=lease&type=due_this_week">{{$count['lease_due_week']}}</a>
                                            </th>
                                        </tr>
                                        
                                        <tr>
                                            <th>Past Due </th>
                                            <th><a target="_blank"
                                                href="report/generator?status=lease&type=past_due">{{$count['lease_past_due']}}</a>
                                            </th>
                                        </tr>
                                        
                                    </tbody>
                                    
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
                
            </div>
            @stop
            
            
            @section('help-links')
            @include('help.help-links',['helpLink'=>config('help-links.help_links.dashboard'),'helpTitle'=>config('help-links.help_titles.dashboard')])
            @endsection
            
            @section('after_scripts')
            
            @include('settings.partials.responsive-fixedheader');
            <!-- Morris -->
            <script src="js/plugins/morris/raphael-2.1.0.min.js"></script>
            <script src="js/plugins/morris/morris.min.js"></script>
            
            <script>
                
                $(function () {
                    
                    Morris.Donut({
                        element: 'morris-donut-chart',
                        data: {!! json_encode($donutAllStatusData) !!},
                        resize: true,
                        colors: ['#337ab7', '#f8ac59', '#1ab394', '#ed5565'],
                        labelColor:"#828282"
                    });
                    
                    Morris.Donut({
                        element: 'morris-donut-chart2',
                        data: {!! json_encode($donutSelectedStatusData) !!},
                        resize: true,
                        colors: ['#337ab7', '#f8ac59', '#1ab394'],
                        labelColor:"#828282"
                    });
                    
                    var months = {!! json_encode($monthNames)!!};
                    // console.log({!! json_encode($assetLineGraphData)!!});
                    Morris.Line({
                        element: 'morris-one-line-chart',
                        data: {!! json_encode($assetLineGraphData) !!},
                        xkey: 'month',
                        ykeys: ['asset'],
                        labels: ['Assets'],
                        xLabelAngle: 60,
                        resize : true,
                        xLabelFormat: function (x) {
                            var month = months[x.getMonth()];
                            return month;
                        },
                        dateFormat: function (x) {
                            var month = months[new Date(x).getMonth()];
                            return month;
                        },
                        
                    });
                    
                });
                
            </script>
            @stop