@extends('layouts.main')
@section('content')
@include('partials.breadcrumb', ['breadcrumbTitle' => 'HR Dashboard'])
@include('dashboard.submenu')
<div class="wrapper-content">
    <div class="container-fluid">
        @include('partials.success')
        <div class="row">
            <div class="col-lg-6">
                <div class="ibox">
                    <div class="ibox-title">
                        <h5>Onboarding</h5>
                    </div>
                    <div class="ibox-content">
                        <form id="onboard-form">
                            <div class="row">

                                <div class="col-lg-6">
                                    <input type="text" name="from_date" id="onboard_from"
                                        class="form-control month-picker" placeholder="Month from">
                                </div>
                                <div class="col-lg-6">
                                    <input type="text" name="to_date" id="onboard_to" class="form-control month-picker"
                                        placeholder="Month to">
                                </div>
                            </div>
                        </form>
                        <br><br>
                        <table class="table table-stripped table-hover" id="onboarding-table">
                            <thead>
                                <tr>
                                    <th>User Type</th>
                                    <th>Users</th>
                                    <th>Laptops / Desktops Assigned</th>
                                </tr>
                            </thead>
                            <tbody>

                            </tbody>
                        </table>
                    </div>
                </div>
            </div>

            <div class="col-lg-6">
                <div class="ibox">
                    <div class="ibox-title">
                        <h5>Terminations</h5>
                    </div>
                    <div class="ibox-content">
                        <form id="termination-form">
                            <div class="row">

                                <div class="col-lg-6">
                                    <input type="text" name="from_date" id="onboard-from"
                                        class="form-control month-picker" placeholder="Month from">
                                </div>
                                <div class="col-lg-6">
                                    <input type="text" name="to_date" id="onboard-to" class="form-control month-picker"
                                        placeholder="Month to">
                                </div>
                            </div>
                        </form>
                        <br><br>
                        <table class="table table-stripped table-hover" id="termination-table">
                            <thead>
                                <tr>
                                    <th>User Type</th>
                                    <th>Users</th>
                                    <th>Uncollected</th>
                                </tr>
                            </thead>
                            <tbody>

                            </tbody>
                        </table>
                    </div>
                </div>
            </div>

            <div class="col-lg-12">
                <div class="ibox">
                    <div class="ibox-title">
                        <h5>Total users in last 12 months</h5>
                        <a href="{{route('hr-dashboard-refresh')}}" class="btn btn-primary"
                            style="float: right;margin-top: -8px;">Refresh</a>
                    </div>
                    <div class="ibox-content">
                        <div class="ajax-loader"><img src="/img/ajax-loader-full-width.gif"></div>
                        <div>
                            <canvas id="barChart" height="140"></canvas>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    @stop

    @section('help-links')
    @include('help.help-links',['helpLink'=>config('help-links.help_links.hr_dashboard'),'helpTitle'=>config('help-links.help_titles.hr_dashboard')])
    @endsection

    @section('after_scripts')
    @include('dashboard.hr-dashboard-script')
    @stop