<script src="/js/Chart.js"></script>
<script src="/js/plugins/dataTables/datatables.min.js"></script>
<script src="/js/plugins/chosen/chosen.ajaxaddition.jquery.js"></script>
<link rel="stylesheet" href="/css/plugins/dataTables/responsive.dataTables.min.css">
<script src="/js/plugins/dataTables/dataTables.responsive.min.js"></script>
<link href="/css/plugins/dataTables/fixedHeader.dataTables.min.css" rel="stylesheet">
<script>
   $(document).ready(function() {   
        $.fn.serializeObject = function(){
           var obj = {};
           $.each( this.serializeArray(), function(i,o){
              var n = o.name, v = o.value;
              obj[n] = obj[n] === undefined ? v
                 : $.isArray( obj[n] ) ? obj[n].concat( v )
                 : [ obj[n], v ];
           });
           return obj;
        };
var onboardingTable = $('#onboarding-table').DataTable({
  "processing": true,
  "serverSide": true,
  "ajax":{
      "url": "{{ route('hr-dashboard-onboarding-summary') }}",
      "dataType": "json",
      "type": "POST",
      "data": function( result ) {
          result.form = $('#onboard-form').serializeObject();
      }
  },
  "columns": [
      { "data": "user_type" },
      { "data": "user_count" },
      { "data": "asset_count" }    
  ],
  lengthMenu: [
      [ 50, 100, 200, -1 ],
      [ '50', '100', '200', 'All' ]
  ],
  columnDefs: [
    { orderable: false, targets: "_all" }
  ],
  "aaSorting": [],
  "dom": '<"top"i>rt<"bottom"flp><"clear">',
  "bAutoWidth": false,
  "bFilter": true,
  "bLengthChange": false,
  "searching": false,
  "responsive": true,
  "scrollCollapse": false,
  "scrollX": false,
  "scrollY": false,
  "paging":false,
  "bInfo": false

});

var terminationTable = $('#termination-table').DataTable({
  "processing": true,
  "serverSide": true,
  "ajax":{
      "url": "{{ route('hr-dashboard-termination-summary') }}",
      "dataType": "json",
      "type": "POST",
      "data": function( result ) {
          result.form = $('#termination-form').serializeObject();
      }
  },
  "columns": [
      { "data": "user_type" },
      { "data": "user_count" },
      { "data": "asset_count" }    
  ],
  lengthMenu: [
      [ 50, 100, 200, -1 ],
      [ '50', '100', '200', 'All' ]
  ],
  columnDefs: [
    { orderable: false, targets: "_all" }
  ],
  "aaSorting": [],
  "dom": '<"top"i>rt<"bottom"flp><"clear">',
  "bAutoWidth": false,
  "bFilter": true,
  "bLengthChange": false,
  "searching": false,
  "responsive": true,
  "scrollCollapse": false,
  "scrollX": false,
  "scrollY": false,
  "paging":false,
  "bInfo": false,

});
$(".month-picker").datepicker({
      format: "mm/yyyy",
      viewMode: "months",
      minViewMode: "months",
      clearBtn: true
  }).on('change', function(e) {
      $(this).closest('form').submit();
  });
 

$('#onboard-form').submit(function(e) {
    e.preventDefault();
    onboardingTable.draw();
});

$('#termination-form').submit(function(e) {
    e.preventDefault();
    terminationTable.draw();
});
});
new Chart("barChart", {
    type: "bar",
    data: {
        labels: {!!json_encode(array_column($totalUsers, 'month')) !!},
        datasets: [{
            backgroundColor: "#4d73be",
            data: {!!json_encode(array_column($totalUsers, 'user_count')) !!}
        }]
    },
    options: {
        legend: {
            display: false
        },
        title: {
            display: true,
            text: ""
        }
    }
});
</script>