@extends('layouts.main')
@section('content')
@include('partials.breadcrumb', ['breadcrumbTitle' => 'Compliance'])
@include('dashboard.submenu')
<div class="wrapper-content">
    @include('partials.success')
    <div class="container-fluid">
    <div class="row">
            @foreach($WidgetData as $widget => $WidgetData)
            <div class="col-md-4">
                    <div class="ibox  match-height-block">
                        <div class="ibox-title"><h5>{{$widget}}  ({{array_sum($WidgetData)}})</h5></div>
                        <div class="ibox-content">
                            @if ($widget == 'Vulnerabilities Found')
                            <table class="table" style="margin-bottom: -12px;">
                                @foreach ($WidgetData as $vulnerabiltyType => $vulnerabiltyCount)
                                <span class="col-lg-6">{{ $vulnerabiltyType }}</span>
                                <span class="col-lg-6"><label> {{ $vulnerabiltyCount }}</label></span>
                                @endforeach
                            </table>
                            @elseif ($widget == 'Lost/Stolen, not Locked' || $widget == 'EOL Wiped without CODD' )
                            <table class="table" style="margin-bottom: -12px;">
                            @if ($widget == 'Lost/Stolen, not Locked')
                                @php $link = 'report/generator?status=stolen_lost&searchData=notLocked&type='; @endphp
                            @else 
                                @php $link = 'report/generator?status=end_of_life_data_wiped&searchData=without_certificate&type='; @endphp
                            @endif
                                <span class="col-lg-6">Laptops</span>
                                <span class="col-lg-6"><label><a target="_blank" href={{$link . "laptop"}} class="font-bold"> {{$WidgetData['Laptops']}}</a></label></span>
                                <span class="col-lg-6">Desktops</span>
                                <span class="col-lg-6"><label><a target="_blank" href={{$link . "desktop"}} class="font-bold">{{$WidgetData['Desktops']}}</a></label></span>
                                <span class="col-lg-6">Chromebooks</span>
                                <span class="col-lg-6"><label><a target="_blank" href={{$link . "chromebook"}} class="font-bold">{{$WidgetData['Chromebooks']}}</a></label></span>
                                <span class="col-lg-6">Tablets</span>
                                <span class="col-lg-6"><label><a target="_blank" href={{$link . "tablet"}} class="font-bold">{{$WidgetData['Tablets']}}</a></label></span>
                                <span class="col-lg-6">Mobile</span>
                                <span class="col-lg-6"><label><a target="_blank" href={{$link . "mobile_phone"}} class="font-bold">{{$WidgetData['Mobiles']}}</a></label></span>
                            </table>
                           
                            @else
                            <table class="table" style="margin-bottom: -12px;">
                                <span class="col-lg-6">Laptops</span>
                                <span class="col-lg-6"><label> {{$WidgetData['Laptops']}}</label></span>
                                <span class="col-lg-6">Desktops</span>
                                <span class="col-lg-6"><label>{{$WidgetData['Desktops']}}</label></span>
                                <span class="col-lg-6">Chromebooks</span>
                                <span class="col-lg-6"><label>{{$WidgetData['Chromebooks']}}</label></span>
                                <span class="col-lg-6">Tablets</span>
                                <span class="col-lg-6"><label>{{$WidgetData['Tablets']}}</label></span>
                                <span class="col-lg-6">Mobile</span>
                                <span class="col-lg-6"><label>{{$WidgetData['Mobiles']}}</label></span>
                            </table>
                            @endif
                        </div>
                    </div>
                </div>
            @endforeach
            <div class="col-lg-12">
                <div class="ibox">
                    <div class="ibox-title">
                        <h5>Total open vulnerabilities in last 10 weeks</h5>
                        <a href="{{route('compliance-dashboard-vulnerability-refresh')}}" class="btn btn-primary"
                            style="float: right;margin-top: -8px;">Refresh</a>
                    </div>
                    <div class="ibox-content">
                        <div class="ajax-loader"><img src="/img/ajax-loader-full-width.gif"></div>
                        <div>
                            <canvas id="barChart" height="140"></canvas>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@stop
@section('after_scripts')
@include('dashboard.scripts.compliance-script')
@stop
@section('help-links')
@include('help.help-links',['helpLink'=>config('help-links.help_links.compliance_dashboard'),'helpTitle'=>config('help-links.help_titles.compliance_dashboard')])
@endsection