@props(['label', 'value', 'editPermission', 'name', 'assetId','showEditButton'])

<dl class="row">
    <dt class="col-sm-4">{{ $label }}</dt>
    <dd class="col-sm-8">
        <label class="no-label minimum-width asset-edit-label">
            <span>{{ $value }}</span>
            
            @if($showEditButton ?? true) 
                @can($editPermission)
                    <a class="edit-input" href="#"><i class="icon icon-n-edit"></i></a>
                @endcan
            @endif
        </label>

        @can($editPermission)
            <input type="text" name="{{ $name }}" 
                class="date-edit-input form-control readonly-white edit-date" 
                autocomplete="off" readonly data-asset-id="{{ $assetId }}">
        @endcan
    </dd>
</dl>

