@props(['label', 'value', 'editPermission', 'name', 'assetId', 'link','labelClass'])
<dl class="row">
    <dt class="col-sm-4">{{ $label }}</dt>
    <dd class="col-sm-8">
        <label class="asset-edit-label {{ $labelClass ?? '' }}">
            @if (isset($link))
                <a href="{{ $link }}" class="edit-serial anchor-asset-tag">{{ $value }}</a>
            @else
                <span>{!! $value !!}</span>
            @endif
            @can($editPermission)
                <a class="edit-input" href="#"><i class="icon icon-n-edit"></i></a>
            @endcan
        </label>
        @can($editPermission)
            <input type="text" name="{{ $name }}" data-asset-id="{{ $assetId }}" class="form-control edit-input-text" autocomplete="off">
        @endcan
        <div id="error{{ $assetId }}"></div>
    </dd>
</dl>
