<script src="/js/plugins/dataTables/datatables.min.js"></script>
<script src="/js/plugins/chosen/chosen.jquery.js"></script>
<script src="/js/plugins/chosen/chosen.ajaxaddition.jquery.js"></script>
<script>
$(document).ready(function() {
    $('.searchable').select2();

    $.fn.serializeObject = function(){
        var obj = {};

        $.each( this.serializeArray(), function(i,o){
            var n = o.name, v = o.value;

            obj[n] = obj[n] === undefined ? v
                : $.isArray( obj[n] ) ? obj[n].concat( v )
                : [ obj[n], v ];
        });

        return obj;
    };

    var table = $('.footable').DataTable({
        "processing": true,
        "serverSide": true,
        "ajax":{
            "url": "{{ route('cloud-assets.data') }}",
            "dataType": "json",
            "type": "POST",
            "data": function( result ) {
                result.form = $('#search-form').serializeObject();
            }
        },
        "columns": [
            { "data": "id" },
            { "data": "name" },
            { "data": "cloud_asset_type" },
            { "data": "identifier" },
            { "data": "instance_state" },
            { "data": "instance_type" },
            { "data": "availability_zone" },
            { "data": "launched_date" },
        ],
        lengthMenu: [
            [ 50, 100, 200],
            [ '50', '100', '200']
        ],
        "dom": '<"top"i>rt<"bottom"flp><"clear">',
        "ordering": false,
        "bAutoWidth": false,
        "bFilter": true,
        "bLengthChange": false,
        "searching": false,
        "fnInitComplete": function (oSettings, json) {
            $("#DataTables_Table_0_paginate").children().before("<p style='float:left; margin-top: 8px'>Last Sync: {{ $lastSyncDate ?? '' }}</p>")
        }
    });

    $('#search-form').submit(function (e) {
        e.preventDefault();
        table.draw();
    });

    $("#search-form .filter-field").on('keyup change', function() {
        $('#search-form').submit();
    });

    $('.input-group.date').datepicker({
        todayBtn: "linked",
        clearBtn: true,
        keyboardNavigation: false,
        forceParse: false,
        autoclose: true,
    }).on('change',function(e){
        $('#search-form').submit();
    });

    $('#export-csv').on('click', function (e) {
        e.preventDefault();
        var pageUrl = $(this).data('url');
        var fileName = $(this).data('file-name');
        var form = $(this).data('filter-form');

        form = (form == undefined) ? "#search-form" : form;
        fileName = (fileName == undefined) ? 'report' : fileName;

        $('.ajax-loader').show();
        $.ajax({
            type: "POST",
            url: pageUrl,
            data: $(form).serializeObject(),
            dataType: 'text',
            success: function (result) {
            var blob = new Blob([result]);
            if (window.navigator.msSaveOrOpenBlob)  // IE hack; see http://msdn.microsoft.com/en-us/library/ie/hh779016.aspx
                window.navigator.msSaveBlob(blob, fileName + ".csv");
            else {
                var a = window.document.createElement("a");
                a.href = window.URL.createObjectURL(blob, { type: "text/plain" });
                a.download = fileName + ".csv";
                document.body.appendChild(a);
                a.click();  // IE: "Access is denied"; see: https://connect.microsoft.com/IE/feedback/details/797361/ie-10-treats-blob-url-as-cross-origin-and-denies-access
                document.body.removeChild(a);
            }
            $('.ajax-loader').hide();
            }
        })
    });

    $(".cloud-assets-filter-field").each(function () {
        var name = $(this).attr('key');
        $(this).select2({
            minimumInputLength: 1,
            multiple: true,
            ajax: {
                url: '{{ route("cloud-assets.filter-field-values") }}',
                dataType: "json",
                data: function (params) {
                    var query = {
                        search: params.term,
                        field: name
                    }

                    return query;
                },
                processResults: function (data) {
                    return {
                        results: data
                    };
                },

            }
        });
    });
});

</script>