<div class="row">
    <div class="col-lg-12">
        <div class="ibox">
            <div class="ibox-title">
                <div class="ibox-tools">
                    <h5>Filters</h5>
                    <a data-toggle="collapse" class="collapse-link" href="#collapseFilter" aria-expanded="true" aria-controls="collapseFilter"><i class="icon icon-e-add" aria-hidden="true"></i></a>
                </div>
            </div>
            <div class="collapse in" id="collapseFilter" aria-expanded="true">
                <div class="ibox-content">
                    <form method="post" id="search-form">
                        {{ csrf_field() }}
                        <div class="row">
                            <div class="col-md-3 divHeight">
                                <div class="form-group">
                                    <label class="control-label">Cloud Asset Type</label>
                                    <select class="form-control filter-field searchable" multiple name="cloud_asset_type" data-placeholder="Select">
                                    @foreach ($cloudAssetTypes as $key => $type)
                                        <option value="{{ $key }}">{{ $type }}</option>
                                    @endforeach
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-3 divHeight">
                                <div class="form-group">
                                    <label class="control-label">Name</label>
                                    <input type="text" name="name" class="form-control filter-field">
                                </div>
                            </div>
                            <div class="col-md-3 divHeight">
                                <div class="form-group">
                                    <label class="control-label">Identifier</label>
                                    <select class="form-control filter-field cloud-assets-filter-field" multiple name="identifier" data-placeholder="Select" key="identifier">
								    </select>
                                </div>
                            </div>
                            <div class="col-md-3 divHeight">
                                <div class="form-group">
                                    <label class="control-label">State</label>
                                    <select class="form-control filter-field searchable" multiple name="instance_state" data-placeholder="Select">
                                        <option value="running">Running</option>
                                        <option value="stopped">Stopped</option>
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-3 divHeight">
                                <div class="form-group">
                                    <label class="control-label">Type</label>
                                    <select class="form-control filter-field cloud-assets-filter-field" multiple name="instance_type" data-placeholder="Select" key="instance_type">
								    </select>
                                </div>
                            </div>

                            <div class="col-md-3 divHeight">
                                <div class="form-group">
                                    <label class="control-label">Region</label>
                                    <select class="form-control filter-field searchable" multiple name="availability_zone" data-placeholder="Select">
                                    @foreach ($regions as $region => $name)
                                        <option value="{{ $region }}">{{ $name }}</option>
                                    @endforeach
								    </select>
                                </div>
                            </div>

                            <div class="col-md-3 divHeight">
                                <div class="form-group">
                                    <label>Launched Date Range</label>
                                    <div class="form-group">
                                        <div class="input-group date">
                                            <span class="input-group-addon"><i class="icon icon-calendar-2"></i></span>
                                            <input type="text" class="form-control readonly-white" placeholder="From" name="date_from" readonly>
                                        </div>
                                    </div>

                                    <div class="form-group">
                                        <div class="input-group date">
                                            <span class="input-group-addon"><i class="icon icon-calendar-2"></i></span>
                                            <input type="text" class="form-control readonly-white" placeholder="To" name="date_to" readonly>
                                        </div>
                                    </div>
                                </div>
                            </div>

                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>