@extends('layouts.main')
@section('content')
@include('partials.breadcrumb', ['breadcrumbTitle' => 'Cloud Assets'])
<div class="wrapper-content">
    <div class="container-fluid">
        <!--- Filters -->
        @include('cloud-assets.partials.filter')

        <div class="row">
            <div class="col-lg-12">
                <div class="ibox">
                    <div class="ibox-title">
                        <div class="ibox-tools">
                            <button type="button" id="export-csv" class="btn btn-primary" data-url="{{ route('cloud-assets.export') }}" data-file-name="cloud-assets">Export to CSV</button>
                        </div>
                    </div>
                    <div class="ibox-content">
                        <div class="ajax-loader"><img src="/img/ajax-loader-full-width.gif"></div>
                        <table class="footable table table-stripped table-hover" data-page-size="50" data-filter=#filter>
                            <thead>
                                <tr>
                                    <th>#</th>
                                    <th>Name</th>
                                    <th>Cloud Asset Type</th>
                                    <th>Identifier</th>
                                    <th>State</th>
                                    <th>Type</th>
                                    <th>Region</th>
                                    <th>Launched Date</th>
                                </tr>
                            </thead>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

@stop
@section('after_scripts')
@include('cloud-assets.scripts.script')
@stop