@extends('layouts.auth')

@section('content')

<h2>Reset Password</h2>

<form method="POST" action="{{ route('password.request') }}">
    {{ csrf_field() }}
    
    <input type="hidden" name="token" value="{{ $token }}">
    
    <div class="form-group{{ $errors->has('email') ? ' has-error' : '' }}">
        <input id="email" type="email" class="form-control" name="email" value="{{ $email ?? old('email') }}" placeholder="E-Mail Address" required autofocus>
        
        @if ($errors->has('email'))
        <span class="help-block">
            <strong>{{ $errors->first('email') }}</strong>
        </span>
        @endif
    </div>
    
    <div class="form-group">
        <input type="password" name="password" class="form-control example2" id="password1" placeholder="Password" value="" required>
        
        @if ($errors->has('password'))
        <span class="help-block">
            <strong>{{ $errors->first('password') }}</strong>
        </span>
        @endif
    </div>
    
    <div class="form-group">
        <input type="password" name="password_confirmation" class="form-control" id="password2" placeholder="Confirm Password" value="" required>
        @if ($errors->has('password_confirmation'))
        <span class="help-block">
            <strong>{{ $errors->first('password_confirmation') }}</strong>
        </span>
        @endif
    </div>
    <button type="submit" class="btn btn-primary btn-block">Update</button>
</form>
@endsection
