@extends('layouts.auth')
@section('content')
<h2>Sign In</h2>

<form role="form" action="login" method="post" autocomplete="off">
    {{csrf_field()}}
    @if (count($errors) > 0)
    @foreach ($errors->all() as $error)
    <div class="alert alert-danger alert-dismissible" role="alert">
        <strong>{{$error}}</strong>
    </div>
    @endforeach
    @endif
    @if(session()->has('saml2_error'))
    @foreach (session()->get('saml2_error') as $samlError)
    <div class="alert alert-danger alert-dismissible" role="alert">
        <strong>{{$samlError}}</strong>
    </div>
    @endforeach
    @endif
    @if(session()->has('saml2_error_single'))
    <div class="alert alert-danger alert-dismissible show" role="alert">
        <strong>{{session('saml2_error_single')}}</strong>
    </div>
    {{session()->forget('saml2_error_single')}}
    @endif
    <div class="form-group">
        
        <input type="email" name="email" class="form-control" placeholder="Username" required="" value="{{old('email')}}">
        
    </div>
    
    <div class="form-group">
        <input type="password" name="password" class="form-control" id="password1" placeholder="Password" value="">
        
    </div>
    
    <button type="submit" class="btn btn-primary btn-block m-b">Login</button>
    @if(cache('azure_sso_config'))
    <p><a href="{{route('saml_login')}}" class="btn btn-primary btn-block m-b">Sign in with SSO</a></p>
    @endif
    <p><a href="/forgot-password" style="text-decoration:none;"><small>Forgot password?</small></a></p>
    
    
</form>

@endsection