@extends('layouts.auth')
@section('content')

<h2>Forgot password</h2>

<p>Enter your email address and your password will be reset and emailed to you.</p>

@if (session('status'))
<div class="alert alert-success">
    {{ session('status') }}
</div>
@endif

<form role="form" method="post" action="{{ route('password.email') }}">
    {{ csrf_field() }}
    <div class="form-group">
        <input type="email" name="email" class="form-control" placeholder="Email address" required="">
    </div>
    
    @if ($errors->has('email'))
    <div class="alert alert-danger">
        {{ $errors->first('email') }}
    </div>
    @endif
    <button type="submit" class="btn btn-primary block full-width m-b">Reset Password</button>
    
</form>


@endsection