<td {{ $lastitem }}>
    @can($editPermission)
        @php
            if ($asset->assetStatus) {
                $statuses = Cache::remember('available_statuses_' . $asset->assetStatus?->slug, 60 * 60, function () use ($asset, $assetStatusService) {
                    return $assetStatusService->availableStatusesForUpdate($asset->assetStatus->slug);
                });
            }
        @endphp
        <select class="form-control selectbox" data-id="{{ $asset->id }}" data-parent="{{ $asset->parent_asset_id }}" data-status="{{ optional($asset->assetStatus)->slug }}" @can($editPermission) @else disabled @endcan>
            @foreach($statuses as $status)
                <option value="{{ $status->id }}" {{ $asset->assetStatus && $asset->assetStatus->id == $status->id ? 'selected disabled' : '' }}>{{ $status->name }}</option>
            @endforeach
        </select>
    @else
        {{ optional($asset->assetStatus)->name }}
    @endcan
</td>