<div class="ibox-content">

    <table class="footable table table-striped collaptable">

        <thead>

            <tr>

                <th>#</th>

                <th>Asset Tag #</th>

                <th>Serial #</th>

                <th>Hardware Standard</th>

                <th>Tech Specs</th>

                <th>Status</th>

                <th>Carrier</th>

                <th>Link</th>

                {{-- <th>Ticket #</th> --}}

                <th>Expected Return Date</th>

            </tr>

        </thead>
        <tbody>

            <?php $countParent = $assets->firstItem();?>

            @forelse($assets as $asset)
            {{-- || count($asset->childrenAsset) == 0 --}}
            @php $parentCount = is_countable($asset->parentAsset) ? count($asset->parentAsset) : 0; @endphp
            @php $assetLink = route('assets.show', $asset->id); @endphp
            
            @if (Route::currentRouteName() == 'mobile-assets.index')
            @php $assetLink = route('mobile-assets.show', $asset->id); @endphp
            @endif

            @if($parentCount == 0 )

            <tr @if( in_array(old('searchText'), [$asset->serial_no, $asset->asset_tag]) && $countParent == 1)
                class="asset-searched-result" @endif data-id="{{$asset->id}}" data-parent="">

                <td>{{(in_array(old('searchText'), [$asset->serial_no, $asset->asset_tag]) && $countParent == 1) ? '' : $countParent++ }}</td>

                <td>
                    <label class="asset-edit-label"><a href="{{$assetLink}}" class="anchor-asset-tag">{{$asset->asset_tag}}</a>
                        @can($editPermission)
                        <a class="edit-input" href="#"><i class="icon icon-n-edit"></i></a>
                        @endcan
                    </label>

                    @can($editPermission)
                    <input type="text" name="asset_tag" data-asset-id="{{ $asset->id }}" class="form-control edit-input-text" autocomplete="off" style="display: none">
                    @endcan
                </td>
                <td>
                    
                    <label class="asset-edit-label"><a href="{{$assetLink}}" class="anchor-asset-tag">{{$asset->serial_no}}</a>
                        @can($editPermission)
                        <a class="edit-input" href="#"><i class="icon icon-n-edit"></i></a>
                        @endcan
                    </label>
                    @can($editPermission)
                        <input type="text" name="serial_no" data-asset-id="{{ $asset->id }}" class="form-control edit-input-text" autocomplete="off" style="display: none">
                        <div id="error{{$asset->id}}"></div>
                    @endcan
                </td>

                <td>{{$asset->makeAndModel->manufacturer->name ?? ''}} &nbsp;- &nbsp;{{$asset->makeAndModel->name ?? ''}}</td>

                <td>{{$asset->technicalSpec->details ?? ''}}</td>

                <td>
                    @can($editPermission)
                    <?php
                    
                    if($asset->assetStatus) {
                        $statuses = Cache::remember('available_statuses_' . $asset->assetStatus?->slug, 60*60, function () use ($asset,$assetStatusService) { 
                            return $assetStatusService->availableStatusesForUpdate($asset->assetStatus->slug); 
                        });
                    }

                    ?>

                    <select class="form-control selectbox" data-id="{{$asset->id}}" data-parent="{{$asset->parent_asset_id}}" @can($editPermission) @else disabled @endcan>

                        @foreach($statuses as $status)

                        <option value="{{$status->id}}" {{$asset->assetStatus ? ($asset->assetStatus->id ==
                            $status->id ? 'selected' : '') : ''}}>{{$status->name}}</option>

                        @endforeach

                    </select>
                    @else
                    {{ optional($asset->assetStatus)->name }}
                    @endcan

                </td>

                <td>
                    @if(Route::currentRouteName() != "mobile-assets.index")
                    {{ $asset->carrier->name ?? ''}}
                    @else
                    @can($editPermission)
                    <select class="form-control carrierbox" data-id="{{$asset->id}}"
                        data-parent="{{$asset->parent_asset_id}}" @can('Mobile Assets Edit') @else disabled @endcan>

                        <option value="">- Select -</option>
                        @foreach($carriers as $carrier)

                        <option value="{{$carrier->id}}" {{$carrier->name ? ($asset->carrier ? ($asset->carrier->id
                            == $carrier->id ? 'selected' : '') : '') : ''}}>{{$carrier->name}}</option>

                        @endforeach

                    </select>
                    @else
                    {{ $asset->carrier->name ?? '' }}
                    @endcan
                    @endif

                </td>

                <td>

                    @if($asset->parent_asset_id != null || count($asset->childrenAsset) > 0)
                    <a href="#" data-toggle="modal" data-target="#link-asset" data-id="{{$asset->id}}"
                        data-parent-id="{{$asset->parent_asset_id}}"><i class="icon icon-link"></i></a>
                    @endif


                </td>

                {{-- <td>{{$asset->ticket_no}}</td> --}}

                <td><label class="no-label minimum-width"><span>{{$asset->loaner_return_date}}</span>
                        @if($asset->loaner_return_date)
                        @can($editPermission)
                        <a class="edit-input" href="#"><i class="icon icon-n-edit"></i></a>
                        @endcan
                        @endif
                    </label>
                    @can($editPermission)
                    <input type="text" name="loaner_return_date" class="date-edit-input form-control readonly-white edit-date" autocomplete="off" readonly data-asset-id="{{$asset->id}}" style="display: none">
                    @endcan
                </td>

            </tr>
            @endif

            
            @if(is_countable($asset->childrenAsset) && count($asset->childrenAsset) > 0)
            <?php $countChild = 0; ?>
            <?php $lastitem = ' '; ?>
            <?php $sizeofChild = is_countable($asset->childrenAsset) ? sizeof($asset->childrenAsset) : 0;?>
            @foreach($asset->childrenAsset as $asset)

            @if(($sizeofChild-1) == $countChild)
            <?php  $lastitem = "class=last"; ?>
            @endif
            @php $assetLink = route('assets.show', $asset->id); @endphp
            @if (Route::currentRouteName() == 'mobile-assets.index')
            @php $assetLink = route('mobile-assets.show', $asset->id); @endphp
            @endif
            <tr @if( in_array(old('searchText'), [$asset->serial_no, $asset->asset_tag]))
                class="asset-searched-result " @endif data-id="{{$asset->id}}" data-id="{{$asset->id}}"
                data-parent="{{$asset->parent_asset_id}}">

                <td {{$lastitem}}>{{$countParent - 1}}.{{++$countChild}}</td>

                <td {{$lastitem}} >
                    <label class="asset-edit-label"><a href="{{$assetLink}}" class="anchor-asset-tag">{{$asset->asset_tag}}</a>
                        @can($editPermission)
                        <a class="edit-input" href="#"><i class="icon icon-n-edit"></i></a>
                        @endcan
                    </label>

                    @can($editPermission)
                    <input type="text" name="asset_tag" data-asset-id="{{ $asset->id }}" class="form-control edit-input-text" autocomplete="off" style="display: none">
                    @endcan
                </td>
                <td {{$lastitem}}>
                    
                    <label class="asset-edit-label"><a href="{{$assetLink}}" class="anchor-asset-tag">{{$asset->serial_no}}</a>
                    
                        @can($editPermission)
                            <a class="edit-input" href="#"><i class="icon icon-n-edit"></i></a>
                        @endcan
                    </label>
                    @can($editPermission)
                        <input type="text" name="serial_no" data-asset-id="{{ $asset->id }}" class="form-control edit-input-text" autocomplete="off" style="display: none">
                        <div id="error{{$asset->id}}"></div>
                    @endcan
                </td>

                <td {{$lastitem}} {{$asset->makeAndModel->manufacturer->name ?? ''}} &nbsp;-
                    &nbsp;{{$asset->makeAndModel->name ?? ''}}</td>

                <td {{$lastitem}}>{{$asset->technicalSpec->details ?? ''}}</td>

                <td {{$lastitem}}>
                    @can($editPermission)
                    <?php
                    if($asset->assetStatus) {
                        $statuses = Cache::remember('available_statuses_' . $asset->assetStatus?->slug, 60*60, function () use ($asset,$assetStatusService) { 
                            return $assetStatusService->availableStatusesForUpdate($asset->assetStatus->slug); 
                        });
                    }
                    ?>

                    <select class="form-control selectbox" data-id="{{$asset->id}}"
                        data-parent="{{$asset->parent_asset_id}}" @can($editPermission) @else disabled @endcan>

                        <option value="">- Select -</option>
                        @foreach($statuses as $status)

                        <option value="{{$status->id}}" {{$asset->assetStatus ? ($asset->assetStatus?->id ==
                            $status->id ? 'selected' : '') : ''}}>{{$status->name}}</option>

                        @endforeach

                    </select>
                    @else
                    {{ optional($asset->assetStatus)->name }}
                    @endcan
                </td>

                <td {{$lastitem}}>{{$asset->carrier->name ?? ''}}</td>

                <td {{$lastitem}}><a href="#" data-toggle="modal" data-target="#link-asset" data-id="{{$asset->id}}"
                        data-parent-id="{{$asset->parent_asset_id}}"><i class="icon icon-link"></i></a></td>

                {{-- <td {{$lastitem}}>{{$asset->ticket_no}}</td> --}}

                <td {{$lastitem}} ><label class="no-label minimum-width"><span>{{$asset->loaner_return_date}}</span>
                    @if($asset->loaner_return_date)
                    @can($editPermission)
                    <a class="edit-input" href="#"><i class="icon icon-n-edit"></i></a>
                    @endcan
                    @endif
                </label>
                @can($editPermission)
                <input type="text" name="loaner_return_date" class="date-edit-input form-control readonly-white edit-date" autocomplete="off" readonly data-asset-id="{{$asset->id}}" style="display: none">
                @endcan
            </td>

            </tr>
            @endforeach
            @endif
            @empty
            <tr>
                <td>No assets found.</td>
            </tr>
            @endforelse

        </tbody>

    </table>

    <div class="pull-right">
        {{$assets->appends(['searchText' => request('searchText'), 'general_type' =>
        request('general_type')])->links()}}

    </div>
</div>