<div class="ibox-content">
    <table class="footable table table-striped collaptable">
        <thead>
            <tr>
                <th>#</th>
                <th>Asset Tag #</th>
                <th>Serial #</th>
                <th>Hardware Standard</th>
                <th>Tech Specs</th>
                <th>Status</th>
                <th>Carrier</th>
                <th>Link</th>
                <th>Expected Return Date</th>
            </tr>
        </thead>
        <tbody>
            <?php $countParent = $assets->firstItem(); ?>

            @forelse($assets as $asset)
                @php
                    $parentCount = is_countable($asset->parentAsset) ? count($asset->parentAsset) : 0;
                    $assetLink = route('assets.show', $asset->id);
                    if (Route::currentRouteName() == 'mobile-assets.index') {
                        $assetLink = route('mobile-assets.show', $asset->id);
                    }
                @endphp

                @if($parentCount == 0)
                    @include('assets.search.partials.asset-row', [
                        'asset' => $asset,
                        'countParent' => $countParent,
                        'assetLink' => $assetLink,
                        'editPermission' => $editPermission,
                        'statuses' => $statuses ?? [],
                        'carriers' => $carriers ?? [],
                        'assetStatusService' => $assetStatusService ?? null
                    ])
                    <?php $countParent++; ?>
                @endif

                @if(is_countable($asset->childrenAsset) && count($asset->childrenAsset) > 0)
                    <?php $countChild = 0; ?>
                    <?php $sizeofChild = sizeof($asset->childrenAsset); ?>
                    @foreach($asset->childrenAsset as $childAsset)
                        @php
                            $lastitem = ($sizeofChild - 1 == $countChild) ? 'class=last' : '';
                            $childAssetLink = route('assets.show', $childAsset->id);
                            if (Route::currentRouteName() == 'mobile-assets.index') {
                                $childAssetLink = route('mobile-assets.show', $childAsset->id);
                            }
                        @endphp

                        @include('assets.search.partials.asset-row', [
                            'asset' => $childAsset,
                            'countParent' => $countParent - 1,
                            'countChild' => ++$countChild,
                            'assetLink' => $childAssetLink,
                            'editPermission' => $editPermission,
                            'statuses' => $statuses ?? [],
                            'carriers' => $carriers ?? [],
                            'assetStatusService' => $assetStatusService ?? null,
                            'lastitem' => $lastitem
                        ])
                    @endforeach
                @endif
            @empty
                <tr>
                    <td colspan="9">No assets found.</td>
                </tr>
            @endforelse
        </tbody>
    </table>

    <div class="pull-right">
        {{ $assets->appends(['searchText' => request('searchText'), 'general_type' => request('general_type')])->links() }}
    </div>
</div>