@extends('layouts.main')
@section('content')
@if(Route::currentRouteName() == "mobile-assets.index")
@can('Mobile Assets View')
@include('assets.submenu-mobile')
@endcan
@elseif(Route::currentRouteName() == "search-network-assets")
@include('assets.submenu-network')
@elseif(Route::currentRouteName() == "av-assets-search")
@include('assets.submenu-prod')
@elseif(Route::currentRouteName() == "search-research-assets")
@include('assets.submenu-research')
@else
@include('assets.submenu')
@endif
@include('partials.breadcrumb', ['breadcrumbTitle' => $breadcrumbTitle])
@inject('assetStatusService', 'App\Services\Asset\AssetStatusService')

@if (Route::currentRouteName() == 'mobile-assets.index')
	@php $editPermission = 'Mobile Assets Edit'; @endphp
	@elseif(Route::currentRouteName() == "search-network-assets")
	@php $editPermission = 'Network Assets Edit'; @endphp
	@elseif(Route::currentRouteName() == "av-assets-search")
	@php $editPermission = 'AV Assets Edit'; @endphp
	@else
	@php $editPermission = 'IT Assets Edit'; @endphp
@endif


<div class="wrapper-content" id="search-asset-design">

	<div class="container-fluid">

		@include('partials.success')

		@include('partials.error-message')

		@include('partials.sync-messages')
		
		@include('assets.search.search-form')

		<div id="update-status">
			<div class="alert alert-success" id="success" style="display: none;"><a href="#" class="close"
					data-dismiss="alert" aria-label="close">&times;</a><strong>Success!</strong> The asset has been
				updated </div>
			<div class="alert alert-danger" id="error" style="display: none;"><a href="#" class="close"
					data-dismiss="alert" aria-label="close">&times;</a><strong>Error!</strong> Do not qualify! The asset
				cannot be updated to the status picked </div>
		</div>

		@if(is_countable($user) && is_countable($location) && count($user) == 0 && count($location) == 0 )
		<div class="row">
			<div class="col-lg-12">
				<div class="ibox">
					<div class="ibox-content text-center">
						<h3>No Assets Are Assigned
							@if ($type == 'mobile')
							Or Search For This Asset In The "IT Assets Tab or Network Assets Tab or AV Assets Tab"
							@elseif ($type == 'network')
							Or Search For This Asset In The "IT Assets Tab or AV Assets Tab or AV Assets Tab"
							@elseif ($type == 'av')
							Or Search For This Asset In The "IT Assets Tab or Network Assets Tab or Mobile Assets Tab"
							@else
							Or Search For This Asset In The "Mobile Assets Tab or Network Assets Tab or AV Assets Tab"
							@endif
						</h3>
					</div>
				</div>
			</div>
		</div>	
		@endif

		
		@if($user)
		<div class="row">
			@include('assets.search.partials.searched-user-detail', ['user' => $user])
		
			@include('assets.search.partials.searched-assets-user', ['editPermission' => $editPermission])
		</div>
		@endif


		@if(isset($softwareUser) && $softwareUser)
		<div class="row">

			@include('assets.search.partials.searched-user-detail', ['user' => $softwareUser])
			@include('assets.search.partials.searched-software-assets', ['editPermission' => $editPermission])
		</div>
		@endif

		@if($location)
		<div class="row">

			@include('assets.search.partials.searched-location-detail', ['location' => $location])			

			@include('assets.search.partials.searched-assets-location', ['user' => $location, 'editPermission' => $editPermission])

		</div>
		@endif

	</div>
	@if($user || $location)
	@include('assets.partials.status-update-modals')
	@endif

	@stop

	@section('help-links')
	@include('help.help-links',['helpLink'=>config('help-links.help_links.assets'),'helpTitle'=>config('help-links.help_titles.assets')])
	@endsection

	@section('after_scripts')
	
	@include('assets.partials.scripts.search')
	@include('assets.partials.scripts.attribute-update-scripts')
	@include('settings.partials.responsive-fixedheader')
	@include('assets.partials.scripts.dropdown-script')
	@if (request('searchText'))
	@include('assets.partials.scripts.original-value-total')
	@endif
	@stop
