@extends('layouts.main')
@section('content')

@include('partials.breadcrumb', ['breadcrumbTitle' => $data['title'], 'parentUrl' => $data['parentUrl'], 'parentTitle' => $data['parent'] ])

@if($data['type'] == 'avassets')
	@include('assets.submenu-prod')
@elseif($data['type'] == 'it')
	@include('assets.submenu')
@elseif($data['type'] == 'mobile')
	@include('assets.submenu-mobile')
@elseif($data['type'] == 'network')
	@include('assets.submenu-network')
@elseif($data['type'] == 'research')
	@include('assets.submenu-research')
@endif

	<div class="wrapper-content">
		<div class="container-fluid">
			<div class="row">
				@include('partials.success')
				<div class="col-lg-3">
					<div class="ibox">
						<div class="ibox-content">
							<div id="error"></div>
							<form action="" id="return-asset-form">
								{{csrf_field()}}
								<input type="hidden" id="count_add" name="count_add" value="0">
								<input type="hidden" id="category" name="category" value="{{$data['type']}}">
								<div class="form-group">
									<label>To</label>
									@include('partials.dropdowns.location-search-input', ['filterClass' => 'filter-field-storage-location','required'=>'required'])
								</div>
								<div class="form-group">
									<label>Ticket #</label>
									<input type="text" class="form-control" name="ticket_no">
								</div>
								<div class="form-group">
									<label>Asset Status</label>
									<select name="asset_status_id" class="form-control select2" id="asset_status_id">
										<option value="">--Select--</option>
										@foreach($assetStatus as $type)
											<option value="{{$type->id}}" {{isset($selected_id) ? ($selected_id == $type->id ? 'selected' : '') : (old('asset_type_id') == $type->id ? 'selected' : '')}}>{{$type->name}}</option>
										@endforeach
									</select>
								</div>
								<div class="form-group">
									<label>Comments</label>
									<textarea cols="30" rows="10" class="form-control" name="comments"></textarea>
								</div>
								<div class="form-group">
									<label>Asset Tag # / Serial #</label>
									<input type="text" class="form-control tag-serial-auto-complete-input" name="serial_no" id="serial_no">
								</div>
								<input type="submit" value="Add" class="btn btn-primary">
							</form>
						</div>
					</div>
				</div>
				<div class="col-lg-9">
					<div class="ibox">
						<div class="ibox-title">
							<h5>Assets (<span id="asset_count"></span>) </h5>
						</div>
						<div class="ibox-content">
							<form method="post" action="{{route('assets-return.store')}}">
							{{csrf_field()}}
							<table id="tblview" class="footable table table-stripped table-hover" data-page-size="8" data-filter=#filter>
								<thead>
									<tr>
										<th>#</th>
										<th>Asset Tag #</th>
										<th>Serial #</th>
										<th>From Status
										<th>To Status</th>
										<th>From</th>
										<th>To</th>
										<th>Ticket #</th>
										<th>Hardware Standard</th>
										<th data-sort-ignore="true"></th>
									</tr>
								</thead>
								<tbody>
								</tbody>
								<tfoot>
									<tr>
										<td colspan="10">
											<ul class="pagination pull-right"></ul>
										</td>
									</tr>
								</tfoot>
							</table>
							<p class="text-right">
								<a href="" class="btn btn-link">Cancel</a>
								<input type="hidden" id="category" name="category" value="{{$data['type']}}">
								<button type="submit" name="commit" id="saveReturnButton" class="btn btn-primary" disabled>Save</button>
							</p>
							</form>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
@stop

@section('help-links')
@include('help.help-links',['helpLink'=>config('help-links.help_links.return_assets'),'helpTitle'=>config('help-links.help_titles.return_assets')])
@endsection

@section('after_scripts')
	@include('assets.partials.scripts.common')
	@include('assets.partials.scripts.dropdown-script')
	@include('assets.return.return-scripts')
@endsection
