<script>
    $(document).ready(function() {

        var table = $('.footable').DataTable({
            responsive: false,
            fixedHeader: true,
            "scrollX": true,
            "processing": true,
            "serverSide": true,
            "ajax": {
                "url": "{{ route('sensor-vulnerability-data') }}",
                "dataType": "json",
                "type": "POST",
                "data": function(result) {
                    result.form = $('#search-form').serializeObject();
                }
            },
            "columns": [
                {"data": 'id'},
                {"data": 'cve_id'},
                {"data": 'exprt_rating'},
                {"data": 'severity'},
                {"data": 'product_name'},
                {"data": 'product_version'},
                {"data": 'days_open'},
            ],
            lengthMenu: [
                [20, 50, 100],
                ['20', '50', '100']
            ],
            columnDefs: [{
                orderable: true,
                targets: '_all'
            }],
            "aaSorting": [],
            "dom": '<"top"i>rt<"bottom"flp><"clear">',
            "bAutoWidth": false,
            "bFilter": true,
            "bLengthChange": false,
            "searching": false,
            "fnDrawCallback": function(oSettings) {
                if (table.page.info().recordsTotal == 0) {
                    $("#export-csv").hide();
                } else {
                    $("#export-csv").show();
                }
            }
        });

        $(".filter-vulnerability-field").each(function() {
            var name = $(this).attr('key');
            $(this).select2({
                minimumInputLength: 1,
                multiple: true,
                ajax: {
                    url: '/get-filter-fields-vulnerability',
                    dataType: "json",
                    data: function(params) {
                        var query = {
                            search: params.term,
                            type: name
                        }

                        // Query parameters will be ?search=[term]&type=public
                        return query;
                    },
                    processResults: function(data) {
                        // Tranforms the top-level key of the response object from 'items' to 'results'
                        return {
                            results: data
                        };
                    },

                }
            });
        });

        $(".report-filter").on('input', function() {
            $('#search-form').submit();
        });

        $(".report-filter").on('change', function() {
            $('#search-form').submit();
        });

        $('#search-form').submit(function(e) {
            e.preventDefault();
            table.draw();
        });

        $('#export-vulnerability-csv').on('click', function(e) {
            e.preventDefault();
            $('.ajax-loader').show();
            $.ajax({
                type: "POST",
                url: "{{route('sensor-vulnerability-export')}}",
                data: $('#search-form').serializeObject(),
                dataType: 'text',
                success: function(result) {
                    var blob = new Blob([result]);
                    if (window.navigator.msSaveOrOpenBlob)
                        window.navigator.msSaveBlob(blob, "assets-vulnerability-report.csv");
                    else {
                        var a = window.document.createElement("a");
                        a.href = window.URL.createObjectURL(blob, {
                            type: "text/plain"
                        });
                        a.download = "assets-vulnerability-report.csv";
                        document.body.appendChild(a);
                        a.click();
                        document.body.removeChild(a);
                    }
                    $('.ajax-loader').hide();
                }
            })
        });
    });
</script>