<script src="/js/plugins/chosen/chosen.jquery.js"></script>
<script src="/js/plugins/dataTables/datatables.min.js"></script>
<script src="/js/plugins/select2/select2.full.min.js"></script>

<script>

	$(document).ready(function() {

		$.fn.serializeObject = function(){
		   var obj = {};
		    
		   $.each( this.serializeArray(), function(i,o){
		      var n = o.name, v = o.value;
		        
		      obj[n] = obj[n] === undefined ? v
		         : $.isArray( obj[n] ) ? obj[n].concat( v )
		         : [ obj[n], v ];
		   });
		    
		   return obj;
		};

		var table = $('.footable').DataTable({

			"processing": true,
	        "serverSide": true,
	        "ajax":{
	            "url": "{{ route('assets-server-data') }}",
	            "dataType": "json",
	            "type": "POST",
	            "data": function( result ) {
	            	result.form = $('#asset-filter-form').serializeObject();
	            }
	        },
	        "columns": [
	            { "data": "id" },
	            { "data": "type" },
	            { "data": "asset_tag" },
	            { "data": "hardware_standard" },
	            { "data": "technical_spec" },
	            { "data": "status" },
	            { "data": "user_location" },
	            { "data": "lease_start_date" },
	            { "data": "lease_end_date" },
	            { "data": "age" },
	            { "data": "modified_date" },
	            { "data": "modified_by" },
	        ],
	        lengthMenu: [
				[ 50, 100, 200],
				[ '50', '100', '200']
			],
			columnDefs: [
	            { orderable: false, targets: 0 }
	        ],
	        'order': [[2, 'asc']],
	        "dom": '<"pull-left"i><"text-center"r><"pull-right"l><t><p>',
	        "createdRow": function( row, data, dataIndex ) {
			    $(row).attr('data-id', data.dataId);
			    $(row).attr('data-parent', data.dataParent);
			    $(row).addClass(data.dataLast ? 'last' : '');
			},
		});

		$(".select2").select2();

		$('.chosen-select').chosen({width: "100%"});



		$('#data_1 .input-group.date').datepicker({

			todayBtn:"linked",

			clearBtn:true,

			keyboardNavigation: false,

			forceParse: false,

			calendarWeeks: false,

			autoclose: true

		});

		$('.i-checks').iCheck({
			checkboxClass: 'icheckbox_square-green',
			radioClass: 'iradio_square-green',
		});

		$('#asset-filter-form').submit(function (e) {

	        e.preventDefault();
	        table.draw();

		});

		$(".filter-field-user").each(function() {
			$( this ).select2({
				minimumInputLength: 1,
	        	multiple: true,
	            ajax: {
	                url: '/get-filter-fields-user',
	                dataType: "json",
	                data: function (params){
				      var query = {
				        search: params.term
				      }

				      // Query parameters will be ?search=[term]&type=public
				      return query;
				    },
				    processResults: function (data) {
				      // Tranforms the top-level key of the response object from 'items' to 'results'
				      return {
				        results: data
				      };
				    },

	            }
		    });
		});

		$(".filter-field-location").each(function() {
			var name = $(this).attr('key');
			$( this ).select2({
				minimumInputLength: 1,
	        	multiple: true,
	            ajax: {
	                url: '/get-filter-fields-location',
	                dataType: "json",
	                data: function (params){
				      var query = {
				        search: params.term,
				        type: name
				      }

				      // Query parameters will be ?search=[term]&type=public
				      return query;
				    },
				    processResults: function (data) {
				      // Tranforms the top-level key of the response object from 'items' to 'results'
				      return {
				        results: data
				      };
				    },

	            }
		    });
		});

		$('.ajax-user').each(function() {
			$( this ).ajaxChosen({
				dataType: 'json',
			}, {
				processItems: function(data){ return data },
				generateUrl: function(q){ return '/get-filter-fields-user?search='+q; },
			},
			{
				width: "100%"
			});
		});

		
	});

</script>