
<script>

    $(document).ready(function () {

       
        $('.data_1 .input-group.date').datepicker({

            todayBtn: "linked",

            clearBtn: true,

            keyboardNavigation: false,

            forceParse: false,

            calendarWeeks: true,

            autoclose: true

        });


        $('.date-edit-input').datepicker({

            todayBtn: "linked",

            clearBtn: true,

            keyboardNavigation: false,

            forceParse: false,

            calendarWeeks: true,

            autoclose: true

        }).on('changeDate', function (e) {

            var parent = $(this).parent();
            var id = $(this).data('asset-id')
            var name = $(this).attr('name');
            var value = $(this).val();
            $(this).hide();
            parent.find('label').show();

            updateAssetAttribute(id, name, value, parent);
        });

        $("#change-user").click(function (e) {
            e.preventDefault();
            $('#asset-change-user-modal').modal('show');
        });


        $("#asset-change-user-submit").on('click', function () {
            $("#asset-change-user-form").validate({
                onkeyup: false,
                excluded: ':disabled',
            });
            $("#asset-change-user-form").submit();
        });

        $('a.edit-input').click(function (e) {
            e.preventDefault();
            var dad = $(this).parent().parent();
            dad.find('label').hide();
            dad.find('input[type="text"]').show().focus();
            dad.find('input[type="text"]').val($.trim($(this).parent().text()));
        });

        $('td input[type=text]').focusout(function () {
            var dad = $(this).parent();
            $(this).hide();
            dad.find('label').show();
        });

        $('a.edit-input-dropdown').click(function (e) {
            e.preventDefault();
            var dad = $(this).parent().parent();
            dad.find('label').hide();
            // Show the dropdown
            var dropdown = dad.find('select.edit-input-select');
            dropdown.show().focus();
        });

        
        $('dd input[type="text"], dd select.edit-input-select').focusout(function () {
            var dad = $(this).parent();
            $(this).hide();
            dad.find('label').show();
        });


        $(document).on('change', '.edit-input-text, .edit-input-select', function (e) {
            e.preventDefault();
            var parent = $(this).parent();
            var id = $(this).data('asset-id')
            var name = $(this).attr('name');
            var value = $(this).val();
            $(this).hide();
            parent.find('label').show();

            updateAssetAttribute(id, name, value, parent);
	    });

        function updateAssetAttribute(assetId, name, value, parent) {
            $.ajax({
                type: "POST",
                url: '/update-asset-attribute',
                data: {attribute: name, value:value, id: assetId},
                success: function(data) {
                    if(data.status){
                        $('#sync-success-msg').text(data.attribute + ' updated successfully.');
                        parent.append(`<span class="inlinemsg label label-success">${data.attribute} updated successfully.</span>`);
                        setTimeout(() => $("body .inlinemsg").fadeOut(), 2000);
                        $('#sync-success').show();
                        // Update the span inside the label with new value
                        if($.inArray(data.attribute, ['Serial #', 'Asset Tag #']) > -1){
                            parent.find('.asset-edit-label .anchor-asset-tag').text(data.value);
                        }else if($.inArray(data.attribute, ['Unlock Code']) > -1){
                            parent.find('.asset-edit-label .lock-label').html(`<a><b><i class="icon icon-b-eye lock-code-view-button" data-asset_id="${assetId}"></i></b></a>`);
                        }else{
                            parent.find('label span').text(data.value);
                        }

                        if ($('.match-height-block').length) {
                            $('.match-height-block').matchHeight({ property: 'height' });
                        }

                        if ($(".asset-history-table").length) {
                            $(".asset-history-table").DataTable().draw();
                            let table = $(".asset-history-table").DataTable();
                            let totalRowCount = table.page.info().recordsTotal; // Get the total number of rows
                            $(".asset-history-count").text(totalRowCount+1); // Update the count display
                        }

                        setTimeout(function () {
                            $('#sync-success').hide();
                        }, 5000);
                    }
                },
                error: function (xhr) {
                    $("body .inlinemsg").hide();
                    let errorMessage = "";

                    if (xhr.status === 422) {
                        // Loop through validation errors
                        let errors = xhr.responseJSON.errors;
                        for (let field in errors) {
                            errorMessage += `<span class="inlinemsg label label-danger">${errors[field][0]}</span>`;
                        }
                    } else {
                        errorMessage = `<span class="inlinemsg label label-danger">An unexpected error occurred. Please try again.</span>`;
                    }
                    // Append all error messages to the parent
                    parent.append(errorMessage);
                    // Hide the error messages after 2 seconds
                    setTimeout(() => $("body .inlinemsg").fadeOut(), 2000);
                }

            });
        }

    });

</script>