<div class="col-lg-12">
	<div class="ibox">
		<div class="ibox-title">
	<div class="ibox-tools">
		<h5>Filters</h5>
		<a data-toggle="collapse" href="#collapseFilter" class="collapse-link"> <i class="icon icon-e-delete"></i></a>
	</div>
</div>
		<div class="collapse in" id="collapseFilter">
			<div class="ibox-content">
				<form method="post" id="search-form" action="">
					{{ csrf_field() }}
					<input type="hidden" name="category" value="it">
					<div class="row">

						<div class="col-md-3">
							<div class="form-group">
								<label class="control-label">Asset Type </label>
								<select class="select2" id="asset_type" multiple name="asset_type"
									data-placeholder="Select">
									@foreach(\App\Models\AssetType::regular() as $assetType)
									<option value="{{$assetType->id}}">{{$assetType->name}}</option>
									@endforeach
								</select>
							</div>
						</div>

						<div class="col-md-3">
							<div class="form-group">
								<label class="control-label">Manufacturer</label>
								<select class="select2" multiple name="manufacturer" id="manufacturer"
									data-placeholder="Select">
									@foreach($manufacturers as $manufacturer)
									<option value="{{$manufacturer->id}}"> {{$manufacturer->name}} </option>
									@endforeach

								</select>
							</div>
						</div>

						<div class="col-md-3">
							<div class="form-group">
								<label class="control-label">Hardware Standard</label>
								<select class="select2" multiple name="make_and_model" id="make_and_model"
									data-placeholder="Select">
									@foreach(Facades\App\Repositories\HardwareStandards::getHardwareStandardsIt() as $hardware)
									<option value="{{$hardware->id}}">{{$hardware->manufacturer}} -
										{{$hardware->makeAndModel}}</option>
									@endforeach

								</select>
							</div>
						</div>

						<div class="col-md-3">
							<div class="form-group">
								<label class="control-label">Technical Specs</label>
								<select class="select2" multiple name="technical_spec" id="technical_spec"
									data-placeholder="Select">
									@foreach(\App\Models\TechnicalSpecs::GetIT()->get() as $technicalSpec)
									<option value="{{$technicalSpec->id}}">{{ $technicalSpec->details}}</option>
									@endforeach
								</select>
							</div>
						</div>
					</div>

					<div class="row">

					<div class="col-md-3">
						<div class="form-group">
							<label class="control-label">Asset Status</label>
							<select class="chosen-select" multiple name="status" data-placeholder="Select">
								@foreach($statuses as $status)
								<option value="{{$status->id}}">{{$status->name}}</option>
								@endforeach
							</select>
						</div>
					</div>

						<div class="col-md-3">
							<div class="form-group">
								<label class="control-label">Asset Tag # </label>
								<select class="filter-field form-control" id="asset_tag" multiple name="asset_tag"
									data-placeholder="Select" key="asset_tag">
								</select>
							</div>
						</div>

						<div class="col-md-3">
							<div class="form-group">
								<label class="control-label">Serial # </label>
								<select class="filter-field form-control" id="serial_no" multiple name="serial_no"
									data-placeholder="Select" key="serial_no">
								</select>
							</div>
						</div>


						<div class="col-md-3">
							<div class="form-group">
								<label class="control-label">User</label>
								<select class="filter-field-user form-control" multiple name="user"
									data-placeholder="Select">
								</select>
							</div>
						</div>

					</div>

					<div class="row">
						<div class="col-md-3">
							<div class="form-group">
								<label class="control-label">Building</label>
								<select class="filter-field-location form-control" multiple name="building"
									data-placeholder="Select" key="building">
								</select>
							</div>
						</div>

						<div class="col-md-3">
							<div class="form-group">
								<label class="control-label">Location</label>
								<select class="filter-field-location form-control" multiple name="location"
									key="room_name" data-placeholder="Select">
								</select>
							</div>
						</div>

						<div class="col-md-3">
							<div class="form-group">
								<label class="control-label">Mobile Carrier</label>
								<select class="chosen-select" multiple name="carrier" data-placeholder="Select">
									@foreach(\App\Models\Carrier::orderBy('slug')->get() as $carrier)
									<option value="{{$carrier->id}}">{{$carrier->name}}</option>
									@endforeach
								</select>
							</div>
						</div>



					</div>

					<div class="row">
						<div class="col-md-3">
							<div class="form-group">
								<label>Lease Start Date Range</label>
								<div class="form-group" id="data_1">
									<div class="input-group date">
										<span class="input-group-addon"><i class="icon icon-calendar-2"></i></span><input
											type="text" name="lease_start_date_from" class="form-control" value=""
											placeholder="From" readonly>
									</div>
								</div>

								<div class="form-group" id="data_1">
									<div class="input-group date">
										<span class="input-group-addon"><i class="icon icon-calendar-2"></i></span><input
											type="text" class="form-control" value="" placeholder="To"
											name="lease_start_date_to" readonly>
									</div>
								</div>
							</div>
						</div>

						<div class="col-md-3">
							<div class="form-group">
								<label>Lease End Date Range</label>
								<div class="form-group" id="data_1">
									<div class="input-group date">
										<span class="input-group-addon"><i class="icon icon-calendar-2"></i></span><input
											type="text" name="lease_end_date_from" class="form-control" value=""
											placeholder="From" readonly>
									</div>
								</div>

								<div class="form-group" id="data_1">
									<div class="input-group date">
										<span class="input-group-addon"><i class="icon icon-calendar-2"></i></span><input
											type="text" class="form-control" value="" placeholder="To"
											name="lease_end_date_to" readonly>
									</div>
								</div>
							</div>
						</div>

						<div class="col-md-3">
							<div class="form-group">
								<label>Expected Return Date Range</label>
								<div class="form-group" id="data_1">
									<div class="input-group date">
										<span class="input-group-addon"><i class="icon icon-calendar-2"></i></span><input
											type="text" class="form-control" value="" placeholder="From"
											name="loaner_return_date_from" readonly>
									</div>
								</div>

								<div class="form-group" id="data_1">
									<div class="input-group date">
										<span class="input-group-addon"><i class="icon icon-calendar-2"></i></span><input
											type="text" class="form-control" value="" placeholder="To"
											name="loaner_return_date_to" readonly>
									</div>
								</div>
							</div>
						</div>

						<div class="col-md-3">
							<div class="form-group">
								<label class="control-label">Asset Age (Older than)</label>
								<div class="row">
									<div class="col-md-6">
										<input type="number" min="0" class="form-control" name="asset_age_value"
											id="asset_age">
									</div>
									<div class="col-md-6">
										<select class="form-control" name="asset_age_unit" id="asset_age_unit">
											<option value="day">Days</option>
											<option value="month">Months</option>
											<option value="year">Years</option>
										</select>
									</div>
								</div>

							</div>
						</div>

					</div>
					<div class="row" id="search_extra_fields">

					</div>


				</form>
			</div>
		</div>
	</div>
</div>