<div class="ibox">
	<div class="ibox-title">
		<div class="ibox-tools">
			<h5>Bulk Upload</h5>
			<a data-toggle="collapse" href="#collapseBulkUpload" class="collapse-link"> <i class="icon icon-e-delete"></i></a>
		</div>
	</div>
	<div class="collapse in" id="collapseBulkUpload">
		<div class="ibox-content">
			@can('IT Assets Edit')
			<form class="form-horizontal" action="{{ route('assets-create.bulk-upload') }}" method="post"
			id="bulk-upload-asset-form" enctype="multipart/form-data">
			{{csrf_field()}}
			<input type="hidden" name="type" value="{{ $data['type'] }}">
			<div class="row">
				<div class="col-lg-4">
					<div class="form-group">
						<label class="col-lg-4 control-label">PO #<span class="text-danger">*</span></label>
						<div class="col-lg-8">
							<input type="text" class="form-control" id="po_id" name="po_id" value="{{old('po_id')}}">
							<div class="errorText"></div>
						</div>
					</div>
				</div>
				<div class="col-lg-4">
					<div class="form-group">
						<label class="col-lg-4 control-label">Vendor<span class="text-danger"></span></label>
						<div class="col-lg-8">
							<select name="vendor_id"
								class="form-control select2">
								<option value="">--Select--</option>
								@foreach($vendors as $vendor)
								<option value="{{$vendor->id}}" {{ old('vendor_id') == $vendor->id ? 'selected' : '' }}>{{$vendor->name}}</option>
								@endforeach
							</select>
							<div class="errorText"></div>
						</div>
					</div>
				</div>
				<div class="col-lg-4">
					<div class="form-group">
						<label class="col-lg-4 control-label">Asset Type<span class="text-danger">*</span></label>
						<div class="col-lg-8">
							<select name="upload_asset_type_id" id="upload_asset_type_id" class="form-control select2">
								<option value="">--Select--</option>
								@foreach($assetTypes as $type)
								<option value="{{$type->id}}" {{isset($selected_id) ? ($selected_id==$type->id ?
									'selected'
									: '') : (old('asset_type_id') == $type->id ? 'selected' : '')}}>{{$type->name}}
								</option>
								@endforeach
							</select>
							<div class="errorText"></div>
						</div>
					</div>
				</div>

				<div class="col-lg-4">
					<div class="form-group">
						<label class="col-lg-4 control-label">Location<span class="text-danger">*</span></label>
						<div class="col-lg-8">
							@include('partials.dropdowns.location-search-input', ['filterClass' =>
							'filter-field-storage-location','required'=>'required'])
							<div class="errorText"></div>
						</div>
					</div>
				</div>
				<div class="col-lg-4">
					<div class="form-group">
						<label class="col-lg-4 control-label">Ticket #</label>
						<div class="col-lg-8">
							<input type="text" class="form-control" name="ticket_no" value="{{old('ticket_no')}}">
							<div class="errorText"></div>
						</div>
					</div>
				</div>
				<div class="col-lg-4">
					<div class="form-group">
						<label class="col-lg-4 control-label">Hardware Standard<span class="text-danger">*</span></label>
						<div class="col-lg-8">
							<select required name="upload_make_and_model_id" id="upload_make_and_model_id"
								class="form-control select2" @if(isset($required) && $required) required @endif>
								<option value="">--Select--</option>
							</select>
							<div class="errorText"></div>
						</div>
					</div>
				</div>

			
				<div class="col-lg-4 upload_phone_number_div">
					<div class="form-group">
						<label class="col-lg-4 control-label">Mobile Carrier<span class="text-danger">*</span></label>
						<div class="col-lg-8">
							<select name="carrier_id" id="carrier_id" class="form-control select2">
								<option value="">--Select--</option>
							</select>
							<div class="errorText"></div>
						</div>
					</div>
				</div>

				<div class="col-lg-4">
					<div class="form-group">
						<label class="col-lg-4 control-label">Tech Specs<span class="text-danger">*</span></label>
						<div class="col-lg-8">
							<select required name="upload_technical_spec_id" id="upload_technical_spec_id"
								class="form-control select2" @if(isset($disabled) && $disabled) disabled @endif
								@if(isset($required) && $required) required @endif>
								<option value="">--Select--</option>
							</select>
							<div class="errorText"></div>
						</div>
					</div>
				</div>
				

				<div class="col-lg-4" @if ($data['type'] !='avassets' ) style="display: none;" @endif>
					<div class="form-group">
						<label class="col-lg-4 control-label">IP Address</label>
						<div class="col-lg-8">
							<input type="text" class="form-control" id="ip" name="ip" value="{{old('ip')}}">
							<div class="errorText"></div>
						</div>
						
						<div class="col-lg-4">
							<div class="form-group">
								<label class="col-lg-4 control-label">Tech Specs<span class="text-danger">*</span></label>
								<div class="col-lg-8">
									<select required name="upload_technical_spec_id" id="upload_technical_spec_id"
									class="form-control select2" @if(isset($disabled) && $disabled) disabled @endif
									@if(isset($required) && $required) required @endif>
									<option value="">--Select--</option>
								</select>
								<div class="errorText"></div>
							</div>
						</div>
					</div>
				</div>

				<div class="col-lg-4">
					<div class="form-group">
						<label class="col-lg-4 control-label">Upload File<span class="text-danger">*</span></label>
						<div class="col-lg-8">
							<div class="fileinput fileinput-new input-group" data-provides="fileinput">
								<div class="form-control" data-trigger="fileinput">
									<i class="glyphicon glyphicon-file fileinput-exists"></i>
									<span class="fileinput-filename"></span>
								</div>
							</div>
							@if ($data['type'] == 'mobile')
								<a href="{{'/template/upload-asset-template-mobile.csv'}}" class="pull-left">Download Template File</a>
							@else
								<a href="{{'/template/upload-asset-template.csv'}}" class="pull-left">Download Template File</a>
							@endif
							<div class="errorTextfile"></div>
						</div>
					</div>
				</div>
			
				
			</div>
			<div class="panel-group" id="accordion-2861553" role="tablist" aria-multiselectable="false">
				<div class="panel panel-default">
					<div class="panel-heading" role="tab" id="heading-8395888">
						<h5 class="panel-title">
							<a role="button" data-toggle="collapse" class="accordion-toggle accordion-arrow-toggle collapsed" data-parent="#accordion-2861553" href="#collapse-8395888" aria-controls="collapse-8395888">Additional Attributes <span class="caret"></span></a>
						</h5>
					</div>
					<div id="collapse-8395888" class="panel-collapse collapse" role="tabpanel" aria-labelledby="heading-8395888">
						<div class="panel-body">
							<div class="row">
								<div class="col-lg-4">
									<div class="form-group">
										<label class="col-lg-4 control-label">Asset Value</label>
										<div class="col-lg-8">
											<input type="text" name="asset_original_value" class="form-control" />
										</div>
									</div>
								</div>
							</div>
							<div class="col-lg-4 lease-fields" style="display: none;">
								<div class="form-group">
									<label class="col-lg-4 control-label">Lease End Date</label>
									<div class="col-lg-8">
										<div class="input-group date">
											<span class="input-group-addon"><i class="icon icon-calendar-2"></i></span>
											<input type="text" class="form-control lease-date" name="lease_end_date"
											value="{{old('lease_end_date')}}" id="lease_end_date" readonly>
											<div class="errorText"></div>
										</div>
									</div>
								</div>
							</div>--}}
							{{-- </div>
							<div class="row"> --}}
								
								<div class="col-lg-4" @if ($data['type'] !='avassets' ) style="display: none;" @endif>
									<div class="form-group">
										<label class="col-lg-4 control-label">IP Address</label>
										<div class="col-lg-8">
											<input type="text" class="form-control" id="ip" name="ip" value="{{old('ip')}}">
											<div class="errorText"></div>
										</div>
									</div>
								</div>
								<div class="col-lg-4" @if ($data['type'] !='avassets' ) style="display: none;" @endif>
									<div class="form-group">
										<label class="col-lg-4 control-label">MAC Address</label>
										<div class="col-lg-8">
											<input type="text" class="form-control" name="mac" id="mac" value="{{old('mac')}}">
											<div class="errorText"></div>
										</div>
									</div>
								</div>
								{{-- </div>
								<div class="row"> --}}
									<div class="col-lg-4">
										<div class="form-group">
											<label class="col-lg-4 control-label">Upload File<span class="text-danger">*</span></label>
											<div class="col-lg-8">
												<div class="fileinput fileinput-new input-group" data-provides="fileinput">
													<div class="form-control" data-trigger="fileinput">
														<i class="glyphicon glyphicon-file fileinput-exists"></i>
														<span class="fileinput-filename"></span>
													</div>
													<span class="input-group-addon btn btn-primary btn-file">
														<span class="fileinput-new">Select file</span>
														<span class="fileinput-exists">Change</span>
														<input type="file" name="bulk_upload_asset_file" id="bulk_upload_asset_file" />
													</span>
													
													<a href="#" class="input-group-addon btn btn-primary fileinput-exists"
													data-dismiss="fileinput">Remove</a>
												</div>
												@if ($data['type'] == 'mobile')
												<a href="{{'/template/upload-asset-template-mobile.csv'}}" class="pull-left">Download Template File</a>
												@else
												<a href="{{'/template/upload-asset-template.csv'}}" class="pull-left">Download Template File</a>
												@endif
												<div class="errorTextfile"></div>
											</div>
										</div>
									</div>
								</div>
								<div class="panel-group" id="accordion-2861553" role="tablist" aria-multiselectable="false">
									<div class="panel panel-default">
										<div class="panel-heading" role="tab" id="heading-8395888">
											<h5 class="panel-title">
												<a role="button" data-toggle="collapse" class="accordion-toggle accordion-arrow-toggle collapsed" data-parent="#accordion-2861553" href="#collapse-8395888" aria-controls="collapse-8395888">Additional Attributes <span class="caret"></span></a>
											</h5>
										</div>
										<div id="collapse-8395888" class="panel-collapse collapse" role="tabpanel" aria-labelledby="heading-8395888">
											<div class="panel-body">
												<div class="row">
													<div class="col-lg-4">
														<div class="form-group">
															<label class="col-lg-4 control-label">Asset Value</label>
															<div class="col-lg-8">
																<input type="text" name="asset_original_value" class="form-control" />
															</div>
														</div>
													</div>
													<div class="col-lg-4">
														<div class="form-group">
															<label class="col-lg-4 control-label">Tracking #</label>
															<div class="col-lg-8">
																<input type="text" class="form-control" name="asset_tracking_id"
																value="{{old('asset_tracking_id')}}" id="asset_tracking_id">
																<div class="errorText"></div>
															</div>
														</div>
													</div>
													<div class="col-lg-4" style="">
														<div class="form-group">
															<label class="col-lg-4 control-label">Warranty End Date</label>
															<div class="col-lg-8">
																<div class="input-group date">
																	<span class="input-group-addon"><i class="icon icon-calendar-2"></i></span>
																	<input type="text" class="form-control lease-date" name="warranty_end_date"
																	value="{{old('warranty_end_date')}}" id="warranty_end_date" readonly>
																	<div class="errorText"></div>
																</div>
															</div>
														</div>
													</div>
													
												</div>
												<div class="row">
													<div class="col-lg-4 lease-fields" style="display: none;">
														<div class="form-group">
															<label class="col-lg-4 control-label">Lease Start Date</label>
															<div class="col-lg-8">
																<div class="input-group date">
																	<span class="input-group-addon"><i class="icon icon-calendar-2"></i></span>
																	<input type="text" class="form-control lease-date"
																	name="lease_start_date" value="{{old('lease_start_date')}}"
																	id="lease_start_date" readonly>
																	<div class="errorText"></div>
																</div>
															</div>
														</div>
													</div>
													<div class="col-lg-4 lease-fields" style="display: none;">
														<div class="form-group">
															<label class="col-lg-4 control-label">Lease End Date</label>
															<div class="col-lg-8">
																<div class="input-group date">
																	<span class="input-group-addon"><i class="icon icon-calendar-2"></i></span>
																	<input type="text" class="form-control lease-date" name="lease_end_date"
																	value="{{old('lease_end_date')}}" id="lease_end_date" readonly>
																	<div class="errorText"></div>
																</div>
															</div>
														</div>
													</div>
												</div>
											</div>
										</div>
									</div>
								</div>
								<p class="text-right">
									<button type="submit" name="commit" class="btn btn-primary" id="added-button">Add & Scroll Down to
										Confirm <i class="icon icon-ctrl-down"></i></button>
									</p>
								</form>
								@endcan
							</div>
						</div>
					</div>
				</div>
			</div>
			<p class="text-right">
				<button type="submit" name="commit" class="btn btn-primary" id="added-button">Add & Scroll Down to
					Confirm <i class="icon icon-ctrl-down"></i></button>
			</p>
		</form>
	</div>
</div>
