
	<link href="/js/plugins/autocomplete/jquery-ui.css" rel="stylesheet">
	<script src="/js/plugins/autocomplete/jquery-ui.min.js"></script>
	
	<script>
		$(".tag-serial-auto-complete-input").autocomplete({
			source: function (request, response) {
				$.ajax({
					url: '/get-search-serial-tag-fields',
					dataType: "json",
					data: {
						search: request.term,
						type: `{{ $data['type'] }}`,
					},
					success: function (data) {
						response($.map(data, function (item) {
							return {
								label: item.label,
								value: item.value,
							}
						}));
					}
				});
			},
			minLength: 1,
			select: function (event, ui) {
				event.preventDefault();
				$(".tag-serial-auto-complete-input").val(ui.item.label);
			}
		});
		
		$("#move-asset-form").validate({
			onkeyup: false,
			onfocusout: false,
			onclick: false,
			rules : {
				location_id : true,
				serial_no: {
					required: true,
					minlength: 2,
					canBeMoved: true,
					unique_fields: [3, 'serial_no'],
				},
				// ticket_no: {
				// 	required: true,
				// }
			},submitHandler: function(form) {
				$('#move-asset-form').find('input.btn').prop('disabled', true);
		        var formData = $('#move-asset-form').serialize();
		      	var count = $('#count_add').val()?$('#count_add').val():0;
		      	count++;
		      	$('#count_add').val(count);
				$('#asset_count').html(count);
		        $.ajax({  
				    type: "POST",  
				    url: "{{route('assets-move.updateRows')}}",  
				    data: formData,  
				    success: function(value) { 
				    	$('tbody').append(value);				    	
			    	    $("input[type='text'][name='serial_no']").val("");
	                    
						$('#count_add').val(count);
						$('#asset_count').html(count);
						$('#move-asset-form').find('input.btn').prop('disabled', false);	
						$('#tblview tbody tr').each(function(index) {
							$(this).find('td:first').text(index + 1);
						});
						$('#saveMoveButton').prop('disabled', false);
					}
				});
			}
		});

		function deleteRows(id) 
	    {
    		$('#'+id).remove();
    		var count = $('#count_add').val();
    		count--;
    		$('#count_add').val(count);
			$('#asset_count').html(count);
			$('#tblview tbody tr').each(function(index) {
				$(this).find('td:first').text(index + 1);
			});

			if(count < 1 || isNaN(count)) {
				$('#saveMoveButton').prop('disabled', true);
			}
		}

		
	</script>