@extends('layouts.main')
@section('content')
@include('partials.breadcrumb', ['breadcrumbTitle' => $data['title']])
@if($data['type'] == 'mobile')
@include('assets.submenu-mobile')
@else
@include('assets.submenu')
@endif
<div class="wrapper-content">
	<div class="container-fluid">
		<div class="row">
			@if($data['type'] == 'mobile')
				@include('assets.partials.filters-mobile-asset',['assetTypes' => 'mobile'])
			@else
				@include('assets.partials.filters')
		 	@endif
		</div>
		
		<div class="ibox">
			<div class="ibox-content">
				@include('partials.success')
				@include('assets.modals.acknowledgment')
				<div class="ajax-loader"><img src="/img/ajax-loader-full-width.gif"></div>
				<div class="dt-coltoggler-wrapper ">
					<p>Click to toggle table columns: </p>
                </div>
				<table id="tblAsset" class="footable table table-striped nowrap has-column-toggler" 
					data-role="ui-data-table" data-filter-form="#search-form"
				 	data-url="{{ route('assets-data') }}" data-searching="false" data-ordering="true" data-page-size="50" 
				 	data-fixed-header="true" data-fixed-header-columns-left="3"> 

					<thead>
						<tr>
							<th data-col-name="id">#</th>
							<th data-col-name="asset_tag">Asset Tag #</th>
							<th data-col-name="serial_no">Serial #</th>
							<th data-col-name="type">Asset Type</th>
							<th data-col-name="hardware_standard">Hardware Standard</th>
							<th data-col-name="technical_spec">Technical Specs</th>
							<th data-col-name="status">Asset Status</th>
							<th data-col-name="user_location">User/Location</th>
							<th data-col-name="carrier">Mobile Carrier</th>
							<th data-col-name="loaner_return_date">Expected Return Date</th>
							<th data-col-name="age">Asset Age</th>
							<th data-col-name="modified_date">Last Modified Date</th>
							<th data-col-name="modified_by">Last Modified By</th>
						</tr>
					</thead>
				</table>
			</div>
		</div>
			
	</div>
</div>
@stop

@section('help-links')
@include('help.help-links',['helpLink'=>config('help-links.help_links.assets'),'helpTitle'=>config('help-links.help_titles.assets')])
@endsection

@section('after_scripts')
	@include('reports.scripts.common')
	@include('reports.scripts.datatable')
	@include('reports.scripts.datatable-column-toggle-script')
	@include('reports.scripts.filter-options-with-ajax')
	@include('assets.partials.script')
	<script src="/js/asset-filter.js"></script>

	<style>
		.i{
			font-size: 16px;
			font-weight: bold;
			margin-right: 2px;
		}
		.last td
		{
			border-bottom: 2px solid black;
		}
		.child
		{
			background: #ccc !important;
		}
		</style>


@stop
