<script>
// Edit Hardware and specs scripts

    var assetHardware = {
        assetType: "{{ $asset->asset_type_id }}",
        makeAndModel: "{{ $asset->make_and_model_id }}",
        technicalSpec: "{{ $asset->technical_spec_id }}"
    };


    $('.edit-hw-specs').click(function (e) {
        e.preventDefault();
        
        $("#edit-hw-specs-form .asset-type").val(assetHardware.assetType).trigger('chosen:updated');

        getHardwareStandards(assetHardware.assetType,assetHardware.makeAndModel);

        getTechSpecs(assetHardware.makeAndModel,assetHardware.technicalSpec);

        $("#editHwSpecsModal").modal('show');
    })

    
    $("#edit-hw-specs-form .asset-type").change(function(){
        $('#edit-hw-specs-form .make-and-model').empty().trigger('chosen:updated');
        $('#edit-hw-specs-form .technical-spec').empty().trigger('chosen:updated');
        getHardwareStandards($(this).val());
    });

    $("#edit-hw-specs-form .make-and-model").change(function(){
        $('#edit-hw-specs-form .technical-spec').empty().trigger('chosen:updated');
        getTechSpecs($(this).val());
    });

    function getHardwareStandards(assettype,currentHardware = null) {
        if (assettype != '' && assettype != '--Select--' && assettype != '0') {
            $.ajax({
                type: "POST", 
                data:{id:assettype, type:''},
                url: "/assets-filter/listHardware",  
                success: function(data) { 
                    $('#edit-hw-specs-form .make-and-model').empty().trigger('chosen:updated');
                    $('#edit-hw-specs-form .make-and-model').append($('<option>', {
                        value: "",
                        text: "Select"
                    }));

                    $.each(data,function (key,value) {
                        $('#edit-hw-specs-form .make-and-model').append($('<option>', {
                        value: value.id,
                        text:  value.hardware  //value.manufacturer.name+" - "+value.name
                        })).trigger('chosen:updated');
                    })

                    if(currentHardware){
                        $('#edit-hw-specs-form .make-and-model').val(currentHardware).trigger('chosen:updated');
                    }

                }
            });
        }
    }

    function getTechSpecs(currentHardware,currentSpec=null) {
        if (currentHardware != '' && currentHardware != '--Select--' && currentHardware != '0') {
            $.ajax({
                type: "POST", 
                data:{id:currentHardware, type:''},
                url: "/assets-filter/listtechnics",  
                success: function(data) { 
                    $('#edit-hw-specs-form .technical-spec').empty().trigger('chosen:updated');
                    
                    $('#edit-hw-specs-form .technical-spec').append($('<option>', {
                        value: "",
                        text: "Select"
                    }));

                    $.each(data,function (key,value) {
                        $('#edit-hw-specs-form .technical-spec').append($('<option>', {
                        value: value.id,
                        text:  value.details  //value.manufacturer.name+" - "+value.name
                        })).trigger('chosen:updated');
                    })

                    if(currentSpec){
                        $('#edit-hw-specs-form .technical-spec').val(currentSpec).trigger('chosen:updated');
                    }

                }
            });
        }
    }

    // Handle the "Save" button click
    $('#edit-hw-specs-submit').click(function(e) {
        e.preventDefault();
        $('#edit-hw-specs-form').submit(); // Trigger the form validation and submission
    });

    // Validate the form
    $("#edit-hw-specs-form").validate({
        ignore: ":hidden:not(select)",
        onfocusout: false,  // Disable validation on field value changes (focus out)
        onkeyup: false,     // Disable validation on keyup events
        rules: {
            asset_type_id: {
                required: true
            },
            make_and_model_id: {
                required: true
            },
            technical_spec_id: {
                required: true
            }
        },
        messages: {
            assettype: {
                required: "Please select an asset type."
            },
            make_and_model_id: {
                required: "Please select a hardware standard."
            },
            technical_spec_id: {
                required: "Please select a tech spec."
            }
        },
        errorPlacement: function (error, element) {
            // Add the 'errorText' class to the error message and place it in the appropriate span
            error.addClass('errorText');
            error.appendTo(element.closest('.form-group').find('.errorText'));
        },submitHandler: function(form) {
            $.ajax({
                url: '/update-hardware-specs',  // Replace with your actual URL
                type: 'POST',
                data: $(form).serialize(),
                success: function(response) {
                    // Handle success
                    location.reload();
                    $('#editHwSpecsModal').modal('hide');
                },
                error: function(xhr) {
                    // Handle error
                }
            });
            return false; // Prevent the form from submitting normally
        }
    });

</script>