<script src="/js/plugins/jasny/jasny-bootstrap.min.js"></script>
<script src="/js/plugins/match-height/jquery.matchHeight.min.js"></script>
<script src="/js/plugins/dataTables/datatables.min.js"></script>
<link href="/css/plugins/dataTables/fixedHeader.dataTables.min.css" rel="stylesheet">
<script>

    $(document).ready(function () {

        $('.match-height-block').matchHeight({ property: 'height' });

        $("#change").click(function () {
            //$("#submit").click();
        });
        $("#change").click(function () {
            if ($("#change").html() == "Change") {
                $("#form-dd").removeClass('hidden');
                $("#change").html("Hide");
            } else {
                $("#form-dd").addClass('hidden');
                $("#change").html("Change");
            }

        });
        $('.asset-status-edit-container').hide();

        $('.edit-asset-status').click(function () {
            $('.asset-status-edit-container').toggle();
            $('.asset-status-edit-container').find('.selectbox').show();
        });

        // $('.footable').footable();

        $('.select2').select2();

        // Asset Link scripts starts
        $("#asset-detail-page-link-btn").click(function (e) {
            e.preventDefault();
            $("#detail-page-link-asset-modal").modal('show');
        });
        $("#asset-detail-link-form-submit").click(function () {
            $("#asset-detail-link-form").submit();
        });

        $("#asset-detail-link-form").validate({
            rules: {
                parent_serial_no: {
                    required: true,
                    minlength: 2,
                    exists: true,
                    parent: true,
                    checkAssetType: true,
                    canBeLinked: true,
                },
                child_serial_no: {
                    required: true,
                    minlength: 2,
                    exists: true,
                    child: true,
                    checkAssetType: true,
                    canBeLinked: true,

                },
                // ticket_no: {
                //     required: true,
                // }
            },
            errorPlacement: function (error, element) {
                error.insertAfter($(element).next($('.errorText')));
            },
        });
        // Asset Link scripts ends

        // Asset Move scripts starts
        $("#asset-detail-page-move-btn").click(function (e) {
            e.preventDefault();
            $("#detail-page-move-asset-modal").modal('show');
        });

        $("#asset-detail-move-form-submit").click(function () {
            $("#asset-detail-move-form").submit();
        });

        $("#asset-detail-move-form").validate({
            ignore: [],
            rules: {
                serial_no: {
                    required: true,
                    minlength: 2,
                    exists: true,
                    canBeMoved: true,
                    checkAssetType: true,
                    addedUnique: 2,
                },
                location_id: true,
                // ticket_no: {
                //     required: true,
                // }
            },
            errorPlacement: function (error, element) {
                error.insertAfter($(element).next($('.errorText')));
            },
        });
        // Asset Move scripts ends

        // Asset Return scripts starts
        $("#asset-detail-page-return-btn").click(function (e) {
            e.preventDefault();
            $("#detail-page-return-asset-modal").modal('show');
        });

        $("#asset-detail-return-form-submit").click(function (e) {
            $("#asset-detail-return-form").submit();
        });

        $("#asset-detail-return-form").validate({
            ignore: [],
            rules: {
                location_id: {
                    required: true,
                },
                serial_no: {
                    required: true,
                    minlength: 2,
                    exists: true,
                    checkAssetType: true,
                    canBeReturned: true,
                    addedUnique: 2,
                },
                asset_status_id: {
                    required: true,
                    canBeUpdated: true,
                },
                // ticket_no: {
                //     required: true,
                // }
            },
            errorPlacement: function (error, element) {
                error.insertAfter($(element).next($('.errorText')));
            },
        });


        $(document).on("click",".lock-code-view-button",function(e){
            e.preventDefault();
            var assetId = $(this).data("asset_id");
            $(".lock-label").html('<i class="icon icon-explore-user"></i>');
            $.ajax({
                type: "POST",
                url: '/get-lock-code',
                data: {asset_id: assetId },
                success: function(data) {
                    if(data.status=='success'){
                        $(".lock-label").html(data.unlock_code+' <a><b><i class="icon icon-b-eye lock-code-hide-button" data-asset_id="'+assetId+'"></i></b></a>');
                        $(".asset-history-table").DataTable().draw();
                        let table = $(".asset-history-table").DataTable();
                        let totalRowCount = table.page.info().recordsTotal; // Get the total number of rows
                        $(".asset-history-count").text(totalRowCount+1); // Update the count display
                    }else{
                        $(".lock-label").html('Lock code not found  <a><b><i class="icon icon-b-eye lock-code-view-button" data-asset_id="'+assetId+'"></i></b></a>');
                    }
                }
            }).fail(function(){
                $(".lock-label").html('<span class="text-danger">Some error occurred.</span> <a><b><i class="icon icon-b-eye lock-code-view-button" data-asset_id="'+assetId+'"></i></b></a>');
            })
        });

        $(document).on("click",".lock-code-hide-button",function(e){
            var assetId = $(this).data("asset_id");
            $(".lock-label").html('<a><b><i class="icon icon-b-eye lock-code-view-button" data-asset_id="'+assetId+'"></i></b></a>');
        });

    });

</script>