<div class="col-md-6 col-lg-4">

    <div class="ibox">

        <div class="ibox-content match-height-block">

            <h3 class="asset-det-h3">Compliance</h3>
            <hr class="asset-det-hr">
            <dl class="row">
                <dt class="col-sm-4">Lock Status</dt>
                <dd class="col-sm-8">
                    <label class="no-label minimum-width asset-edit-label">
                        <span>{{ $asset->lockStatus?->name }}</span>
                        @can($editPermission)
                            <a class="edit-input-dropdown" href="#"><i class="icon icon-n-edit"></i></a>
                        @endcan
                    </label>
                    @can($editPermission)

                        <input type="hidden" value="{{$asset->id}}">
                        @php
                            $lockStatuses = App\Models\LockStatus::all(); // Get all lock statuses
                        @endphp
                        <select name="lock_status_id" data-asset-id="{{ $asset->id }}" class="form-control edit-input-select"  >
                            @foreach($lockStatuses as $status)
                                <option value="{{ $status->id }}" {{ $status->id == $asset->lock_status_id ? 'selected' : '' }}>
                                    {{ $status->name }}
                                </option>
                            @endforeach
                        </select>
                    @endcan
                </dd>
            </dl>
            
            <x-asset-detail-items.editable-attribute 
                label="Lock Notes" 
                :value="$asset->lock_notes ? $asset->lock_notes: ''" 
                name="lock_notes" 
                :asset-id="$asset->id" 
                :editPermission="$editPermission"
                labelClass="no-label minimum-width"/>

            <dl class="row">
                <dt class="col-sm-4">Unlock Code</dt>
                <dd class="col-sm-8" title="click to view lock code">
                    <label class="no-label minimum-width asset-edit-label">
                        <span class="lock-label">
                        @if($asset->unlock_code)
                            <a><b><i class="icon icon-b-eye lock-code-view-button" data-asset_id="{{ $asset->id }}"></i></b></a>
                        @endif
                        </span>

                        @can($editPermission)
                            <a class="edit-input" href="javascript:"><i class="icon icon-n-edit"></i></a>
                        @endcan
                    </label>
                    @can($editPermission)
                        <input type="text" name="unlock_code" data-asset-id="{{ $asset->id }}" value="{{ $asset->unlock_code }}" class="form-control edit-input-text" autocomplete="off" >
                    @endcan
                </dd>
            </dl>
            <x-asset-detail-items.asset-detail-item label="Legal Hold" :value="''" />

            <x-asset-detail-items.asset-detail-item label="Back Up Date" :value="''" />

            <x-asset-detail-items.asset-detail-item label="Back Up %" :value="''" />

            <x-asset-detail-items.asset-detail-item label="Stolen/Lost Date" :value="$asset->lost_date" />

            <x-asset-detail-items.asset-detail-item label="ITAD Uploaded Date" :value="$asset->certificate_added_date ?? ''" />

            <dl class="row">
                <dt class="col-sm-4">ITAD Certificate</dt>

                @if($asset->ewaste_certificate)
                <dd class="col-sm-8">
                    <a href="/download-eol-certificate/{{$asset->id}}">
                        {{ strlen(basename($asset->ewaste_certificate)) > 20 ?
                            substr(basename($asset->ewaste_certificate), 0, 20) . "..." :
                        basename($asset->ewaste_certificate) }}
                    </a>
                </dd>

                @else
                <dd class="col-sm-8"></dd>

                @endif

            </dl>

            <x-asset-detail-items.asset-detail-item label="Sensor Installed" :value="$asset->sensor_detected ?? ''" />

            <x-asset-detail-items.asset-detail-item label="Retain Hold Wipe Confirmation #" :value="$asset->wipe_confirmation" />

            <x-asset-detail-items.asset-detail-item label="Retain Hold Wipe Confirmation Date" :value="$asset->retain_hold_wipe_confirmation_date" />

            <x-asset-detail-items.asset-detail-item label="Retain Hold Notes" :value="$asset->retain_hold_note" />
        </div>

    </div>

</div>