<div class="col-md-6 col-lg-4">

    <div class="ibox">

        <div class="ibox-content match-height-block">
            <h3 class="asset-det-h3">Asset Status</h3>
            <hr class="asset-det-hr">
            
            <x-asset-detail-items.asset-detail-item label="Ticket #" :value="$asset->ticket_no" />

            <dl class="row">

                <dt class="col-sm-4">Asset Status</dt>
                <dd class="col-sm-8">
                    <label class="text-font asset-status-container asset-edit-label">
                        <span class="edit-po"> {{ optional($asset->assetStatus)->name }} </span>
                        @can($editPermission)
                        <a class="edit-asset-status" href="javascript:void(0)"><i
                                class="icon icon-n-edit"></i></a>
                        @endcan
                    </label>
                    <br>
                    @can($editPermission)
                    <label class="label-normal-font asset-status-edit-container">
                        <select class="form-control selectbox" data-id="{{ $asset->id }}"
                            data-parent="{{ $asset->parent_asset_id }}" data-status="{{ optional($asset->assetStatus)->slug }}"
                            @can($editPermission) @else disabled @endcan>
                            @foreach ($statuses as $status)
                            <option value="{{ $status->id }}" {{ $asset->assetStatus ?
                                ($asset->assetStatus->id == $status->id ? 'selected disabled' : '') : '' }}>{{
                                $status->name }}</option>
                            @endforeach
                        </select>
                    </label>
                    @endcan

                </dd>

            </dl>
            <dl class="row">

                <dt class="col-sm-4">Location</dt>
                <dd class="col-sm-8">
                    @if (@isset($asset->location) && !empty($asset->location->room_name))
                    <a
                        href="{{ route('location.show', $asset->location->id) }}">{{optional($asset->location)->room_name}}</a>
                    @endif
                </dd>

            </dl>
            <dl class="row">

                <dt class="col-sm-4">User</dt>
                <dd class="col-sm-8">
                    @if (@isset($asset->user) && !empty($asset->user->first_name))
                    <a href="{{ route('users.show', $asset->user->id) }}"> {{
                        optional($asset->user)->first_name
                        }} {{ optional($asset->user)->last_name }}</a>
                    @can($editPermission)
                    <a id="change-user" href="#"><i class="icon icon-n-edit"></i></a>
                    @endcan
                    @endif
                </dd>

            </dl>
            <x-asset-detail-items.asset-detail-item label="Email" :value="optional($asset->user)->email" />

            <x-asset-detail-items.asset-detail-item label="User Type" :value="optional(optional($asset->user)->userType)->name" />
                
            <x-asset-detail-items.asset-detail-item label="Network Code" :value="''" />

        </div>

    </div>

</div>