<div class="col-md-6 col-lg-4">

    <div class="ibox">

        <div class="ibox-content match-height-block">
            <h3 class="asset-det-h3">Asset Details</h3>
            <hr class="asset-det-hr">

            <x-asset-detail-items.hardware-standard-item 
                label="Asset Type" 
                :value="optional($asset->assetType)->name" 
                :editPermission="$editPermission" 
            />

            <x-asset-detail-items.hardware-standard-item 
                label="Hardware Standard" 
                :value="optional(optional($asset->makeAndModel)->manufacturer)->name . ' ' . optional($asset->makeAndModel)->name" 
                :editPermission="$editPermission" 
            />

            <x-asset-detail-items.hardware-standard-item 
                label="Tech Specs" 
                :value="optional($asset->technicalSpec)->details" 
                :editPermission="$editPermission" 
            />

            <x-asset-detail-items.editable-attribute 
                label="Asset Tag #" 
                :value="$asset->asset_tag" 
                name="asset_tag" 
                :asset-id="$asset->id" 
                :editPermission="$editPermission"
                :link="$assetLink"
            />
            

            <x-asset-detail-items.editable-attribute 
                label="Serial #" 
                :value="$asset->serial_no" 
                name="serial_no" 
                :asset-id="$asset->id" 
                :editPermission="$editPermission"
                :link="$assetLink"
            />

            <x-asset-detail-items.asset-detail-item label="IMEI" :value="$asset->imei" />
            <x-asset-detail-items.asset-detail-item label="Asset Age" :value="$asset->assetAge" />
                
            <dl class="row">

                <dt class="col-sm-4">Parent Asset</dt>
                <dd class="col-sm-8">
                    @if(isset($asset->parentAsset))
                    <a target="__blank"
                        href="{{route('assets.show', $asset->parentAsset->id)}}">{{isset($asset->parentAsset)
                        ? $asset->parentAsset->serial_no : ''}}</a>
                    @endif
                </dd>
            </dl>
            <dl class="row">

                <dt class="col-sm-4">Child Asset</dt>
                <dd class="col-sm-8">
                    @foreach($asset->childrenAsset as $childs)
                    <a target="__blank"
                        href="{{route('assets.show', $childs->id)}}">{{$childs->serial_no}}</a>
                    @endforeach
                </dd>
            </dl>

        </div>

    </div>

</div>