@extends('layouts.main')
@section('content')
@if($data['type'] == 'avassets')
@include('assets.submenu-prod')
@elseif($data['type'] == 'it')
@include('assets.submenu')
@elseif($data['type'] == 'mobile')
@include('assets.submenu-mobile')
@elseif($data['type'] == 'network')
@include('assets.submenu-network')
@elseif($data['type'] == 'research')
@include('assets.submenu-research')
@endif
@include('partials.breadcrumb', ['breadcrumbTitle' => $data['title'], 'parentUrl' => $data['parentUrl'], 'parentTitle'
=> $data['parent']])
<style>
	.errors-tests-head {
		font-size: 14px;
		font-weight: 600;
		color: #f00;
	}

	.warnings-tests-head {
		font-size: 14px;
		font-weight: 600;
		color: #ff4e0e;
	}

	.notices-tests-head {
		font-size: 14px;
		font-weight: 600;
		color: #337ab7;
	}
</style>
<div class="wrapper wrapper-content asset-detail-outer">

	<div class="container-fluid">

		<div class="row">

			@include('partials.error')
			@include('partials.success')
			@include('partials.error-message')

			@if (Route::currentRouteName() == 'mobile-assets.show')
			@php $editPermission = 'Mobile Assets Edit'; @endphp
			@elseif(Route::currentRouteName() == "search-network-assets")
			@php $editPermission = 'Network Assets Edit'; @endphp
			@elseif(Route::currentRouteName() == "av-assets-search")
			@php $editPermission = 'AV Assets Edit'; @endphp
			@elseif(Route::currentRouteName() == "search-research-assets")
			@php $editPermission = 'Research Assets Edit'; @endphp
			@else
			@php $editPermission = 'IT Assets Edit'; @endphp
			@endif
			@include('partials.error')
			@php $assetLink = route('assets.show', $asset->id); @endphp
			@if (Route::currentRouteName() == 'mobile-assets.show')
			@php $assetLink = route('mobile-assets.show', $asset->id); @endphp
			@endif

			@if(session()->has('success-message'))
			<div class="alert  alert-success">
				{{ session()->get('success-message') }}
			</div>
			@endif
			@if(session()->has('error-message'))
			<div class="alert  alert-danger">
				{{ session()->get('error-message') }}
			</div>
			@endif
		</div>
		@if($asset!=null)
		<div class="row">
			@include('partials.sync-messages')

			<!-- <div class="col-lg-12">
				<div class="ibox">

					<div class="ibox-content match-height-block bg-danger">
						<h2>Legal Hold - 60% Backed up </h2>
					</div>
				</div>
			</div> -->
            @include('assets.detail-page.partials.asset-action-buttons')

            @include('assets.detail-page.partials.asset-details-section')

            @include('assets.detail-page.partials.asset-status-section')

            @include('assets.detail-page.partials.dates-section')

            @include('assets.detail-page.partials.procurement-section')

            @include('assets.detail-page.partials.end-point-section')

            @include('assets.detail-page.partials.compliance-section')

            @include('assets.detail-page.partials.revivn-section')

			@include('assets.detail-page.partials.zoom-section')

		</div>

		@else
		<div class="row">
			<div class="col-sm-12">
				<h2>Asset Not Found</h2>
			</div>
		</div>

		@endif




    @if ($asset->assetVulnerabilty && count($asset->assetVulnerabilty) > 0)
		@include('assets.partials.assets-vulnerability')
	@endif



	@if($asset!=null)
	<div class="row">

		<div class="col-lg-12">

			<div class="ibox">

				<div class="ibox-title">

					<h5>Comments (<span id="asset_count">{{count($asset->assetComment)}}</span>)
						<span><a href='' data-toggle='modal' data-asset-id="{{$asset->id}}"
								data-target='#add-comment-modal'><i class="icon icon-n-edit"></i></a></span>
					</h5>

				</div>

				@include('assets.partials.comment', ['comments' => $asset->assetComment ])

			</div>
		</div>
	</div>

	<div class="ibox">
		<div class="ibox-title">
			<h5>Asset History (<span class="asset-history-count" id="asset_count">{{ is_countable($asset->assethistory) ? count($asset->assethistory) : 0}}</span>) </h5>
		</div>
		@include('assets.partials.history')
	</div>

	<div class="row">

		<div class="col-lg-12">

			<div class="ibox">

				<div class="ibox-title">

					<h5>Asset Health</h5>

				</div>

				@include('assets.partials.health', ['healthReports' => $assetHealth ])

			</div>

		</div>

	</div>

	@endif
	</div>
</div>
@if($asset!=null)
@include('assets.partials.status-update-modals')
@include('assets.modals.add-comment')
@include('assets.modals.change-user')
@include('assets.detail-page.modals.detail-page-link-asset')
@include('assets.detail-page.modals.detail-page-move-asset')
@include('assets.detail-page.modals.detail-page-return-asset')
@include('assets.detail-page.modals.edit-hw-specs-modal')
@endif
@stop

@section('help-links')
@include('help.help-links',['helpLink'=>config('help-links.help_links.assets'),'helpTitle'=>config('help-links.help_titles.assets')])
@endsection

@section('after_scripts')
@include('assets.partials.scripts.search')
@include('assets.partials.scripts.dropdown-script')
@include('assets.detail-page.scripts.detail-scripts')
@include('assets.partials.scripts.attribute-update-scripts')
@include('assets.detail-page.scripts.edit-hw-specs-scripts')

@include('security.crowdstrike.scripts.common')
@include('assets.partials.scripts.vulnerability-script')
@include('reports.scripts.common')
@include('reports.scripts.datatable')

@endsection
