@extends('layouts.main')
@section('content')

@include('assets.partials.submenu')

@include('partials.breadcrumb', ['breadcrumbTitle' => $data['title'], 'parentUrl' => $data['parentUrl'], 'parentTitle' => $data['parent'] ])

<div class="wrapper-content">
	<div class="container-fluid create-asset-panel">

        @include('partials.error')
		
		@include('assets.create.forms.create-form')

		@include('assets.create.forms.bulk-upload-form')

		@include('assets.create.forms.advanced-upload-form')
			
		
		<div class="ibox">
			<div class="alert alert-danger" style="display: none;" id="assetUploadErrorDiv">
			</div>
			<div class="ibox-title">
				<h5>Assets (<span id="asset_count"></span>) </h5>
			</div>
			<div class="ibox-content">
				<form method="post" action="{{route('assets-create.store')}}" id="bulk-upload-asset-table-form">
					{{csrf_field()}}
					<table id="tblview" class="footable table table-stripped  fixed_header main-table" data-page-size="50"
						data-filter=#filter>
						<input type="hidden" id="category" name="category" value="{{$data['type']}}">
						<thead>
							<tr>
								<th>#</th>
								<th>PO #</th>
								<th>Vendor</th>
								<th>Location</th>
								<th>Asset Type</th>
								<th>Hardware Standard</th>
								<th>Tech Specs</th>
								<th>Asset Tag #</th>
								<th>Serial #</th>
								<th></th>
							</tr>
						</thead>
						<tbody>
						</tbody>
						<tfoot>
							<tr>
								<td colspan="10">
									<ul class="pagination pull-right"></ul>
								</td>
							</tr>
						</tfoot>
					</table>
					<p class="text-right">
						<button type="button" name="commit" id="createAssetBtn" class="btn btn-primary bulk-upload-save-button"
							disabled>Save</button>
					</p>
				</form>
			</div>
		</div>

	</div>
</div>
@stop
@section('help-links')
@include('help.help-links',['helpLink'=>config('help-links.help_links.create_assets'),'helpTitle'=>config('help-links.help_titles.create_assets')])
@endsection

@section('after_scripts')
<link href="/css/plugins/dataTables/fixedHeader.dataTables.min.css" rel="stylesheet">
@include('assets.partials.scripts.common')
@include('assets.create.scripts.create-scripts')
@include('assets.create.scripts.asset-type-handler-scripts')
@include('assets.create.scripts.bulk-upload-scripts')
@include('assets.partials.scripts.dropdown-script')
@endsection
