@extends('layouts.main')
@section('content')
@include('partials.breadcrumb', ['breadcrumbTitle' => $data['title'], 'parentUrl' => $data['parentUrl'], 'parentTitle'
=> $data['parent'] ])
@if($data['type'] == 'server')
@include('assets.submenu-prod')
@elseif($data['type'] == 'it')
@include('assets.submenu')
@elseif($data['type'] == 'mobile')
@include('assets.submenu-mobile')
@endif

<div class="wrapper-content">
	<div class="container-fluid create-asset-panel">
		<div class="ibox">
			<div class="ibox-content">
				<form class="form-horizontal" action="{{route('assets-create.create')}}" method="post"
				id="create-asset-form">
				{{csrf_field()}}
				<input type="hidden" id="count_add" name="count_add" value="0">
				<input type="hidden" id="row_count" name="row_count" value="0">
				<input type="hidden" id="category" name="category" value="{{$data['type']}}">
				<div class="row">
					<div class="col-lg-12">@include('partials.error')</div>
				</div>
				<div class="row">
					<div class="col-lg-4">
						<div class="form-group">
							<label class="col-lg-4 control-label">PO #<span
								class="text-danger">*</span></label>
								<div class="col-lg-8">
									<input type="text" class="form-control" id="po_id" name="po_id"
									value="{{old('po_id')}}">
									<div class="errorText"></div>
								</div>
							</div>
						</div>
						<div class="col-lg-4">
							<div class="form-group">
								<label class="col-lg-4 control-label">Vendor<span
									class="text-danger"></span></label>
									<div class="col-lg-8">
										<select name="vendor_id" id="vendor_id"
										class="form-control select2">
										<option value="">--Select--</option>
										@foreach($vendors as $vendor)
										<option value="{{$vendor->id}}" {{ old('vendor_id') == $vendor->id ? 'selected' : '' }}>{{$vendor->name}}</option>
										@endforeach
									</select>
									<div class="errorText"></div>
								</div>
							</div>
						</div>
						<div class="col-lg-4">
							<div class="form-group">
								<label class="col-lg-4 control-label">Asset Type<span
									class="text-danger">*</span></label>
									<div class="col-lg-8">
										{{-- @include('partials.dropdowns.asset-type') --}}
										<select name="asset_type_id" id="asset_type_id"
										class="form-control select2">
										<option value="">--Select--</option>
										@foreach($assetTypes as $type)
										<option value="{{$type->id}}" {{isset($selected_id) ?
											($selected_id==$type->id ? 'selected' : '') : (old('asset_type_id')
											== $type->id ? 'selected' : '')}}>{{$type->name}}</option>
											@endforeach
										</select>
										<div class="errorText"></div>
									</div>
								</div>
							</div>
							<div class="col-lg-4 no_phone_number_div">
								<div class=" form-group">
									<label class="col-lg-4 control-label assetTagLabel">Asset Tag #<span
										class="text-danger">*</span></label>
										<div class="col-lg-8">
											<input type="text" class="form-control" id="asset_tag" name="asset_tag"
											value="{{old('asset_tag')}}">
											<div class="errorText"></div>
										</div>
									</div>
								</div>
								<div class="col-lg-4 phone_number_div">
									<div class="form-group">
										<label class="col-lg-4 control-label">Mobile Carrier<span
											class="text-danger">*</span></label>
											<div class="col-lg-8">
												<select name="carrier_id" id="carriers" class="form-control select2">
													<option value="">--Select--</option>
												</select>
												<div class="errorText"></div>
											</div>
										</div>
									</div>
									<div class="col-lg-4">
										<div class="form-group">
											<label class="col-lg-4 control-label">Location<span
												class="text-danger">*</span></label>
												<div class="col-lg-8">
													@include('partials.dropdowns.location-search-input', ['filterClass' =>
'filter-field-storage-location','required'=>'required'])
													<div class="errorText"></div>
												</div>
											</div>
										</div>
										<div class="col-lg-4">
											<div class="form-group">
												<label class="col-lg-4 control-label">Hardware Standard<span
													class="text-danger">*</span></label>
													<div class="col-lg-8">
														<select required name="make_and_model_id" id="make_and_model_id"
														class="form-control select2" @if(isset($required) && $required) required
														@endif>
														<option value="">--Select--</option>
													</select>
													<div class="errorText"></div>
												</div>
											</div>
										</div>
										<div class="col-lg-4">
											<div class="form-group">
												<label class="lblserial_and_phone col-lg-4 control-label">Serial #<span
													class="text-danger">*</span></label>
													<div class="col-lg-8">
														<input type="text" class="form-control" id="serial_no" name="serial_no"
														value="{{old('serial_no')}}">
														<div class="errorText"></div>
													</div>
												</div>
											</div>
											<div class="col-lg-4">
												<div class="form-group">
													<label class="col-lg-4 control-label">Ticket #</label>
														<div class="col-lg-8">
															<input type="text" class="form-control" name="ticket_no"
															value="{{old('ticket_no')}}" id="ticket_no">
															<div class="errorText"></div>
														</div>
													</div>
												</div>
												<div class="col-lg-4">
													<div class="form-group">
														<label class="col-lg-4 control-label">Tech Specs<span
															class="text-danger">*</span></label>
															<div class="col-lg-8">
																<select required name="technical_spec_id" id="technical_spec_id"
																class="form-control select2" @if(isset($disabled) && $disabled) disabled
																@endif @if(isset($required) && $required) required @endif>
																<option value="">--Select--</option>
															</select>
															<div class="errorText"></div>
														</div>
													</div>
												</div>
												<div class="col-lg-4 mobilephone">
													<div class="form-group ">
														<label class=" col-lg-4 control-label">IMEI #<span
															class="text-danger">*</span></label>
															<div class="col-lg-8">
																<input type="text" class="form-control" id="imei" name="imei"
																value="{{old('imei')}}">
																<div class="errorText"></div>
															</div>
														</div>
													</div>
												</div>
												<div class="row" id="extra_fields">
													<!--Special fields -->
													<!-- End of Special Fields-->
												</div>
												<div class="panel-group" id="accordion-2861552" role="tablist" aria-multiselectable="false">
													<div class="panel panel-default">
														<div class="panel-heading" role="tab" id="heading-8395887">
															<h5 class="panel-title">
																<a role="button" data-toggle="collapse" class="accordion-toggle accordion-arrow-toggle collapsed" data-parent="#accordion-2861552" href="#collapse-8395887" aria-controls="collapse-8395887">Additional Attributes <span class="caret"></span></a>
															</h5>
														</div>
														<div id="collapse-8395887" class="panel-collapse collapse" role="tabpanel" aria-labelledby="heading-8395887">
															<div class="panel-body">
																<div class="row">
																	<div class="col-lg-4">
																		<div class="form-group">
																			<label class="col-lg-4 control-label">Asset Value</label>
																			<div class="col-lg-8">
																				<input type="text" name="asset_original_value" class="form-control" />
																			</div>
																		</div>
																	</div>
																	<div class="col-lg-4">
																		<div class="form-group">
																			<label class="col-lg-4 control-label">Tracking #</label>
																			<div class="col-lg-8">
																				<input type="text" class="form-control" name="asset_tracking_id"
																				value="{{old('asset_tracking_id')}}" id="asset_tracking_id">
																				<div class="errorText"></div>
																			</div>
																		</div>
																	</div>
																	<div class="col-lg-4" style="">
																		<div class="form-group">
																			<label class="col-lg-4 control-label">Warranty End Date</label>
																			<div class="col-lg-8">
																				<div class="input-group date">
																					<span class="input-group-addon"><i class="icon icon-calendar-2"></i></span>
																					<input type="text" class="form-control lease-date" name="warranty_end_date"
																					value="{{old('warranty_end_date')}}" id="warranty_end_date" readonly>
																					<div class="errorText"></div>
																				</div>
																			</div>
																		</div>
																	</div>
																	
																</div>
																<div class="row">
																	<div class="col-lg-4 lease-fields" style="display: none;">
																		<div class="form-group">
																			<label class="col-lg-4 control-label">Lease Start Date</label>
																			<div class="col-lg-8">
																				<div class="input-group date">
																					<span class="input-group-addon"><i class="icon icon-calendar-2"></i></span>
																					<input type="text" class="form-control lease-date"
																					name="lease_start_date" value="{{old('lease_start_date')}}"
																					id="lease_start_date" readonly>
																					<div class="errorText"></div>
																				</div>
																			</div>
																		</div>
																	</div>
																	<div class="col-lg-4 lease-fields" style="display: none;">
																		<div class="form-group">
																			<label class="col-lg-4 control-label">Lease End Date</label>
																			<div class="col-lg-8">
																				<div class="input-group date">
																					<span class="input-group-addon"><i class="icon icon-calendar-2"></i></span>
																					<input type="text" class="form-control lease-date" name="lease_end_date"
																					value="{{old('lease_end_date')}}" id="lease_end_date" readonly>
																					<div class="errorText"></div>
																				</div>
																			</div>
																		</div>
																	</div>
																</div>
															</div>
														</div>
													</div>
												</div>
												<p class="text-right">
													<button type="submit" name="commit" class="btn btn-primary" id="add-button">Add & Scroll Down to Confirm <i class="icon icon-ctrl-down"></i></button>
												</p>
											</form>
										</div>
									</div>
									
									
									@include('assets.partials.bulk-upload-form')
									@can('Bulk Upload')
									<div class="ibox">
										<div class="ibox-title">
											<div class="ibox-tools">
												<h5>Advanced Bulk Upload</h5>
												<a data-toggle="collapse" href="#collapseAdvancedBulkUpload" class="collapse-link"> <i class="icon icon-e-delete"></i></a>
											</div>
										</div>
										<div class="collapse in" id="collapseAdvancedBulkUpload">
											<div class="ibox-content">
												
												<form class="form-horizontal"
												action="{{$data['type'] != 'mobile' ? route('assets-create.upload') : route('assets-create.mobile.upload') }}"
												method="post" id="upload-asset-form" enctype="multipart/form-data">
												{{csrf_field()}}
												<div class="row">
													<div class="col-lg-4">
														<div class="form-group">
															
															<div class="col-lg-12">
																<div class="fileinput fileinput-new input-group" data-provides="fileinput">
																	<div class="form-control" data-trigger="fileinput">
																		<i class="glyphicon glyphicon-file fileinput-exists"></i>
																		<span class="fileinput-filename"></span>
																	</div>
																	<span class="input-group-addon btn btn-primary btn-file">
																		<span class="fileinput-new">Select file</span>
																		<span class="fileinput-exists">Change</span>
																		<input type="file" name="bulk_upload_asset"
																		id="bulk_upload_asset" />
																	</span>
																	<a href="#" class="input-group-addon btn btn-primary fileinput-exists"
																	data-dismiss="fileinput">Remove</a>
																</div>
																<a href="{{$data['type'] != 'mobile' ? '/template/asset-template.csv' : '/template/asset-template-mobile.csv'}}" class="pull-right">Download Template File</a>
																<div class="advanced-upload-error-div"></div>
															</div>
														</div>
													</div>
													<div class="col-lg-6 col-lg-offset-2 text-right">
														<button type="submit" name="commit" class="btn btn-primary" id="upload-button">Add & Scroll Down to Confirm <i class="icon icon-ctrl-down"></i></button>
													</div>
													
												</div>
											</form>
											
										</div>
									</div>
								</div>
								@endcan
								
								<div class="ibox">
									<div class="alert alert-danger" style="display: none;" id="assetUploadErrorDiv">
									</div>
									<div class="ibox-title">
										<h5>Assets (<span id="asset_count"></span>) </h5>
									</div>
									<div class="ibox-content">
										<form method="post" action="{{route('assets-create.store')}}" id="bulk-upload-asset-table-form">
											{{csrf_field()}}
											<table id="tblview" class="footable table table-stripped table-hover" data-page-size="50"
											data-filter=#filter>
											<input type="hidden" id="category" name="category" value="{{$data['type']}}">
											<thead>
												<tr>
													<th>#</th>
													<th>PO #</th>
													<th>Vendor</th>
													<th>Location</th>
													<th>Asset Type</th>
													<th>Hardware Standard</th>
													<th>Tech Specs</th>
													<th>Asset Tag #</th>
													<th>Serial #</th>
													<th></th>
												</tr>
											</thead>
											<tbody>
											</tbody>
											<tfoot>
												<tr>
													<td colspan="10">
														<ul class="pagination pull-right"></ul>
													</td>
												</tr>
											</tfoot>
										</table>
										<p class="text-right">
											<button type="button" name="commit" id="createAssetBtn" class="btn btn-primary bulk-upload-save-button"
											disabled>Save</button>
										</p>
									</form>
								</div>
							</div>
							
						</div>
					</div>
					@stop
					@section('help-links')
					@include('help.help-links',['helpLink'=>config('help-links.help_links.create_assets'),'helpTitle'=>config('help-links.help_titles.create_assets')])
					@endsection
					
					@section('after_scripts')
					<link href="/css/plugins/dataTables/fixedHeader.dataTables.min.css" rel="stylesheet">
					@include('assets.partials.scripts.common')
					@include('assets.partials.scripts.create')
					@include('assets.partials.scripts.dropdown-script')
					@include('assets.partials.scripts.bulk-upload')
					@endsection
					