@extends('layouts.main')
@section('content')
@include('assets.submenu-research')
@include('partials.breadcrumb', ['breadcrumbTitle' => $data['title'], 'parentUrl' => $data['parentUrl'], 'parentTitle' => $data['parent'] ])
<div class="wrapper-content">
	<div class="container-fluid">
		<div class="ibox">
			<div class="ibox-content">
				<form class="form-horizontal" action="{{route('research-assets.create')}}" method="post" id="create-research-asset-form">
					{{csrf_field()}}
					<input type="hidden" id="count_add" name="count_add" value="0">
					<div class="row">
						<div class="col-lg-12">@include('partials.error')</div>
					</div>				
					<div class="row">
						<div class="col-lg-4">
							<div class="form-group">
								<label class="col-lg-4 control-label">PO #</label>
								<div class="col-lg-8">
									<input type="text" class="form-control" name="po_id" value="{{old('po_id')}}">
									<div class="errorText"></div>
								</div>
							</div>		
						</div>
						<div class="col-lg-4">
							<div class="form-group">
								<label class="col-lg-4 control-label">Asset Type</label>
								<div class="col-lg-8">
									{{--@include('partials.dropdowns.asset-type')--}}
									<select name="asset_type_id" id="asset_type_id" class="form-control select2">
										<option value="">--Select--</option>
										@foreach($assetTypes as $type)
										<option value="{{$type->id}}" {{isset($selected_id) ? ($selected_id == $type->id ? 'selected' : '') : (old('asset_type_id') == $type->id ? 'selected' : '')}}>{{$type->name}}</option>
										@endforeach
									</select>
									<div class="errorText"></div>
								</div>
							</div>		
						</div>
						<div class="col-lg-4 no_phone_number_div">
							<div class="no_phone_number_div form-group">
								<label class="col-lg-4 control-label assetTagLabel">Asset Tag #</label>
								<div class="col-lg-8">
									<input type="text" class="form-control" id="asset_tag" name="asset_tag" value="{{old('asset_tag')}}">
									<div class="errorText"></div>
								</div>
							</div>	
						</div>
						<div class="col-lg-4 phone_number_div">
							<div  class="form-group" >
								<label class="col-lg-4 control-label">Mobile Carrier</label>
								<div class="col-lg-8">
									<select name="carrier_id" id="carriers" class="form-control select2">
										<option value="">--Select--</option>
									</select>
									<div class="errorText"></div>
								</div>
							</div>
						</div>		
						<div class="col-lg-4">
							<div class="form-group">
								<label class="col-lg-4 control-label">Location</label>
								<div class="col-lg-8">
									@include('partials.dropdowns.location-active')
									<div class="errorText"></div>
								</div>
							</div>		
						</div>
						<div class="col-lg-4">
							<div class="form-group">
								<label class="col-lg-4 control-label label-height">Hardware Standard</label>
								<div class="col-lg-8">
									<select required name="make_and_model_id" id="make_and_model_id" class="form-control select2" 
									@if(isset($required) && $required) required @endif 
									@if(isset($disabled) && $disabled) disabled @endif
									>
									<option value="">--Select--</option>
								</select>
								<div class="errorText"></div>
							</div>
						</div>		
					</div>
					<div class="col-lg-4">
						<div class="form-group">
							<label class="lblserial_and_phone col-lg-4 control-label">Serial #</label>
							<div class="col-lg-8">
								<input type="text" class="form-control" id="serial_no" name="serial_no" value="{{old('serial_no')}}">
								<div class="errorText"></div>
							</div>
						</div>	
					</div>
					<div class="col-lg-4">
						<div class="form-group">
							<label class="col-lg-4 control-label">Ticket #</label>
							<div class="col-lg-8">
								<input type="text" class="form-control" name="ticket_no" value="{{old('ticket_no')}}">
								<div class="errorText"></div>
							</div>
						</div>		
					</div>
					<div class="col-lg-4">
						<div class="form-group">
							<label class="col-lg-4 control-label">Tech Specs</label>
							<div class="col-lg-8">
								
								<select required name="technical_spec_id" id="technical_spec_id" class="form-control select2" 
								@if(isset($disabled) && $disabled) disabled @endif
								@if(isset($required) && $required) required @endif
								>
								<option value="">--Select--</option>
							</select>
							<div class="errorText"></div>
						</div>
					</div>		
				</div>
				<div class="col-lg-4 mobilephone">
					<div class="form-group ">
						<label class=" col-lg-4 control-label">IMEI #</label>
						<div class="col-lg-8">
							<input type="text" class="form-control" id="imei" name="imei" value="{{old('imei')}}">
							<div class="errorText"></div>
						</div>
					</div>	
				</div>
			</div>
			<p class="text-right">
				<button type="submit" name="commit" class="btn btn-primary" id="add-button">Add & Scroll Down to Confirm <i class="icon icon-ctrl-down"></i></button>
			</p>
		</form>
	</div>
</div>
@include('assets.partials.bulk-upload-form')
@can('Bulk Upload')
<div class="ibox">
	<div class="ibox-title">
		<div class="ibox-tools">
			<h5>Advanced Bulk Upload</h5>
			<a data-toggle="collapse" href="#collapseAdvancedBulkUpload" class="collapse-link"> <i class="icon icon-e-delete"></i></a>
		</div>
	</div>
	<div class="collapse in" id="collapseAdvancedBulkUpload">
		<div class="ibox-content">
			<form class="form-horizontal" action="research-assets/upload" method="post" id="upload-asset-form" enctype="multipart/form-data">
				{{csrf_field()}}
				<div class="row">
					<div class="col-lg-8">
						<div class="form-group">
							<label class="col-lg-4 control-label">Bulk Upload</label>
							<div class="col-lg-8">
								<div class="fileinput fileinput-new input-group" data-provides="fileinput">
									<div class="form-control" data-trigger="fileinput">
										<i class="glyphicon glyphicon-file fileinput-exists"></i>
										<span class="fileinput-filename"></span>
									</div>
									<span class="input-group-addon btn btn-primary btn-file">
										<span class="fileinput-new">Select file</span>
										<span class="fileinput-exists">Change</span>
										<input type="file" name="bulk_upload_asset" id="bulk_upload_asset" />
									</span>
									<a href="#" class="input-group-addon btn btn-primary fileinput-exists" data-dismiss="fileinput">Remove</a>
								</div> 
								<a href="/template/research-assets-template.csv" class="pull-right">Download Template File</a>
							</div>
						</div>
					</div>
					<div class="col-lg-4">
						<button type="submit" name="commit" class="btn btn-primary" id="upload-button">Add & Scroll Down to Confirm <i class="icon icon-ctrl-down"></i></button>
						
					</div>
				</div>
			</form>
		</div>
	</div>
</div>
@endcan

<div class="ibox">
	<div class="ibox-title">
		<h5>Assets (<span id="asset_count"></span>) </h5>
	</div>
	<div class="ibox-content">
		<form class="form-horizontal" action="{{ route('research-assets.store') }}" method="post" id="create-network-form">
			{{csrf_field()}}
			<table id="tblview" class="footable table table-stripped table-hover" data-page-size="50" data-filter=#filter>
				<thead>
					<tr>
						<th>PO #</th>
						<th>Location</th>
						<th>Hardware Standard</th>
						<th>Tech Specs</th>
						<th>Asset Tag #</th>
						<th>Serial#</th>
					</tr>
				</thead>
				<tbody>
					
				</tbody>
				<tfoot>
					<tr>
						<td colspan="10">
							<ul class="pagination pull-right"></ul>
						</td>
					</tr>
				</tfoot>
			</table>
			<p class="text-right">
				<button type="submit" name="commit" class="btn btn-primary">Save</button>
			</p>
		</form>
	</div>
</div>
</div>
</div>
@stop

@section('after_scripts')
@include('assets.partials.scripts.common')
@include('assets.partials.scripts.create')
@include('assets.partials.scripts.bulk-upload')

@include('assets.partials.scripts.form-submit-ajax', [
'form_id' => 'create-research-asset-form',
'route_name' => 'research-assets.updateRows'
])
@endsection

@section('help')
@include('help.assets-create')
@endsection