@extends('layouts.main')
@section('content')
@include('partials.breadcrumb', ['breadcrumbTitle' => $data->assetHealthTest ? $data->assetHealthTest->test_name."" : "", 'parentUrl' => '/asset-health', 'parentTitle' => 'Asset Health'])
@include('assets-health.submenu')
<style type="text/css">
    .ibox-title {
        border-top: none !important;
    }
    .form-group, .table {
        text-align: left;
    }
    .ibox-tools a {
        color: #4d73be;
    }
</style>

<div class="wrapper-content">
    <div class="container-fluid">
        <!-- Cost Analysis graph - full page width  - Start -->
        <div class="row">
            <div class="col-lg-12">

                <div class="ibox" >
                    <div class="ibox-title">
                        <h5 style="margin-bottom: 20px;"> <span id="test_detail_count">{{$data->testCount}}</span>&nbsp;Issues with {{$data->assetHealthTest ? $data->assetHealthTest->test_name : ""}}</h5>
                        <input type="hidden" id="asset_health_report_id" value="{{$data->id}}">
                        <div class="ibox-tools" style="clear: both;">
                            <a href="/asset-health-ignored-test-detail/{{ $data->id }}" class="btn btn-primary pull-left">Ignored Assets</a>
                            <a data-toggle="modal" data-target="#createTicketModal" id="create-ticket" class="btn btn-primary">Create Ticket</a>
                            <a href="#" id="export-csv" class="btn btn-primary">Export to CSV</a>
                        </div>
                    </div>

                    <div class="ibox-content">
                        @include('partials.success')
                        @include('partials.error-message')
                        <div class="ajax-loader"><img src="/img/ajax-loader-full-width.gif"></div>
                        <div class="ibox-title">
                            {{-- <div class="ibox-tools">

                                <a href="#" data-id='' data-toggle='modal' data-target='#how_to_fix_modal'>Why and How to Fix</a>
                            </div> --}}
                        </div>
                        <div class="table-responsive">
                            <table class="footable table table-stripped table-hover" data-page-size="50" data-filter=#filter>
                                <thead>
                                    <tr>
                                        @foreach(config('asset-health.datatable_columns')[$data->assetHealthTest->slug ?? 'default'] as $key => $label)
                                            <th>{{ $label }}</th>
                                        @endforeach
                                        <th>Mark as Ignored</th>
									</tr>
                                </thead>
                                <tbody>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>


<div class="modal inmodal" id="createTicketModal" tabindex="-1" role="dialog" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content animated fadeIn">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal"><span aria-hidden="true">×</span><span
                        class="sr-only">Close</span></button>

                <h4 class="modal-title">Create Ticket</h4>

            </div>
            <div class="modal-body">
                <form  method="post" action="/assets-health-tests-create-ticket">
                    {{csrf_field()}}
                        <div class="form-group">
                            <label>Summary</label>
                            <input type="text" class="form-control" name="summary">
                        </div>
                        <div class="form-group">
                            <label>Description</label>
                            <textarea cols="30" rows="10" class="form-control" name="description"></textarea>
                        </div>
                        <div class="form-group" style="text-align: right;">
                            <input type="submit" value="Create" class="btn btn-primary">
                        </div>
                </form>
            </div>
        </div>
    </div>
</div>
@stop
@section('after_scripts')
@include('assets-health.scripts.test-detail')
@include('assets-health.modals.how-to-fix')
@stop
