<script src="/js/plugins/chosen/chosen.jquery.js"></script>
<script src="/js/plugins/dataTables/datatables.min.js"></script>
<script src="/js/plugins/chosen/chosen.ajaxaddition.jquery.js"></script>
<script src="/js/plugins/dataTables/dataTables.responsive.min.js"></script>
<link href="/css/plugins/dataTables/fixedHeader.dataTables.min.css" rel="stylesheet">
<link rel="stylesheet" href="/css/plugins/dataTables/responsive.dataTables.min.css">
<!-- Morris -->
<script src="/js/plugins/morris/raphael-2.1.0.min.js"></script>
<script src="/js/plugins/morris/morris.min.js"></script>
<script type="text/javascript">
    @php $tableColumns = []; @endphp
    @foreach(config('asset-health.datatable_columns')[$data->assetHealthTest->slug ?? 'default'] as $key => $label)
        @php $tableColumns[] = ['data' => $key]; @endphp
    @endforeach
    @php $tableColumns[] = ['data' => 'ignore']; @endphp

    $(document).ready(function() {
        $('.chosen-select').chosen({width: "100%"}).change(function() {
            $(this).closest('.form-group').next().find('input').focus();
        });

        $.fn.serializeObject = function(){
           var obj = {};

           $.each( this.serializeArray(), function(i,o){
              var n = o.name, v = o.value;

              obj[n] = obj[n] === undefined ? v
                 : $.isArray( obj[n] ) ? obj[n].concat( v )
                 : [ obj[n], v ];
           });

           return obj;
        };
        var testReportId = $("#asset_health_report_id").val();
        var table = $('.footable').DataTable({
            "processing": true,
            "serverSide": true,
            "ajax":{
                "url": "/assets-health-test-detail/"+testReportId,
                "dataType": "json",
                "type": "POST",
                "data": function( result ) {
                    result.form = $('#search-form').serializeObject();
                }
            },
            "drawCallback": function (settings) {
                // Here the response
                var response = settings.json;
                $("#test_detail_count").html(response.recordsTotal);
            },
            "columns": @json($tableColumns),
            lengthMenu: [
                [ 50, 100, 200, -1 ],
                [ '50', '100', '200', 'All' ]
            ],
            columnDefs: [
               { orderable: false, targets: [0, 1, 2, 3, 4, 5, 6,7] }
            ],
            "aaSorting": [],
            "dom": '<"top"i>rt<"bottom"flp><"clear">',
            "bAutoWidth": false,
            "bFilter": true,
            "bLengthChange": false,
            "searching": false,
            "responsive": true,
            "scrollCollapse": false,
            "scrollX": false,
            "scrollY": false,
            "fnRowCallback" : function(nRow, aData, iDisplayIndex){
                var oSettings = this.fnSettings();
                $("td:first", nRow).html(oSettings._iDisplayStart+iDisplayIndex +1);
                return nRow;
            },
        });

        var table = $('.ignored-footable').DataTable({
            "processing": true,
            "serverSide": true,
            "ajax":{
                "url": "/assets-health-ignored-test-detail/"+testReportId,
                "dataType": "json",
                "type": "POST",
                "data": function( result ) {
                    result.form = $('#search-form').serializeObject();
                }
            },
            "drawCallback": function (settings) {
                // Here the response
                var response = settings.json;
                $("#test_detail_count").html(response.recordsTotal);
            },
            "columns": @json($tableColumns),
            lengthMenu: [
                [ 50, 100, 200, -1 ],
                [ '50', '100', '200', 'All' ]
            ],
            columnDefs: [
               { orderable: false, targets: [0, 1, 2, 3, 4, 5, 6,7] }
            ],
            "aaSorting": [],
            "dom": '<"top"i>rt<"bottom"flp><"clear">',
            "bAutoWidth": false,
            "bFilter": true,
            "bLengthChange": false,
            "searching": false,
            "responsive": true,
            "scrollCollapse": false,
            "scrollX": false,
            "scrollY": false,
            "fnRowCallback" : function(nRow, aData, iDisplayIndex){
                var oSettings = this.fnSettings();
                $("td:first", nRow).html(oSettings._iDisplayStart+iDisplayIndex +1);
                return nRow;
            },
        });
        var delay = (function(){
            var timer = 0;
            return function(callback, ms){
                clearTimeout (timer);
                timer = setTimeout(callback, ms);
            };
        })();

        //Datatable column toggler
        $('span.col-toggle').on( 'click', function (e) {
            e.preventDefault();
            $(this).toggleClass('col-hidden');
            // Get the column API object
            var column = table.column( $(this).attr('data-column') );

            // Toggle the visibility
            column.visible( ! column.visible() );
        });


        $('#export-csv').on('click', function(e) {
            e.preventDefault();
            $('body').removeClass('pace-done').addClass('pace-running');
            $('.pace').removeClass('pace-inactive').addClass('pace-active');
            $.ajax({
                type: "POST",
                url: "/assets-health-test-detail-export/"+testReportId,
                data: $('#search-form').serializeObject(),
                dataType: 'text',
                success: function(result) {
                    var blob = new Blob([result]);
                    if (window.navigator.msSaveOrOpenBlob)  // IE hack; see http://msdn.microsoft.com/en-us/library/ie/hh779016.aspx
                        window.navigator.msSaveBlob(blob, "test_report.csv");
                    else
                    {
                        var a = window.document.createElement("a");
                        a.href = window.URL.createObjectURL(blob, {type: "text/plain"});
                        a.download = "test_report.csv";
                        document.body.appendChild(a);
                        a.click();  // IE: "Access is denied"; see: https://connect.microsoft.com/IE/feedback/details/797361/ie-10-treats-blob-url-as-cross-origin-and-denies-access
                        document.body.removeChild(a);
                    }
                    $('body').removeClass('pace-running').addClass('pace-done');
                    $('.pace').removeClass('pace-active').addClass('pace-inactive');
                }
            })
        });

        $("#confirm_sync").on('click', function(e){
            e.preventDefault();

            $("#manualSyncModel").modal('show');
        })

        $('#continue_sync').on('click', function(e) {
            e.preventDefault();
            $('body').removeClass('pace-done').addClass('pace-running');
            $('.pace').removeClass('pace-inactive').addClass('pace-active');
            $("#manualSyncModel").modal('hide');
            $.ajax({
                type: "POST",
                url: "{{route('assets-health-reports-sync')}}",
                dataType: 'json',
                success: function(result) {
                    $('body').removeClass('pace-running').addClass('pace-done');
                    $('.pace').removeClass('pace-active').addClass('pace-inactive');
                    $('#sync-success').show();

                    var message = result.message;
                    var count = result.count;
                    $('#sync-success span').html(message + ' Total Issues Found: ' + count);

                    setTimeout(function () {
                        location.reload();
                    }, 2000);
                },
                error: function(response) {
                    $('body').removeClass('pace-running').addClass('pace-done');
                    $('.pace').removeClass('pace-active').addClass('pace-inactive');
                    $('#sync-error').show();
                    $('#sync-error span').text('Sync Failed.');
                }
            })
        });

        $("body").on("click", ".toggle-ignore-btn", function(e) {
            e.preventDefault();
            
            var href = $(this).attr('href');
                    
            if (!href) {
                return;
            }

            // Dynamically create a form.
            var form = $('<form>', {
                method: 'POST',
                action: href
            });

            form.append($('<input>', {
                type: 'hidden',
                name: '_token',
                value: '{{ csrf_token() }}'
            }));

            // Append the form to the body and submit.
            form.appendTo('body').submit();
        });

    });
</script>
