<script>
    $(document).ready(function() {
        $('#download-report-csv').on('click', function(e) {
            e.preventDefault();
            $('body').removeClass('pace-done').addClass('pace-running');
            $('.pace').removeClass('pace-inactive').addClass('pace-active');
            $.ajax({
                type: "POST",
                url: "/assets-health-report-download-csv",
                dataType: 'text',
                success: function(result) {
                    $('body').removeClass('pace-running').addClass('pace-done');
                    $('.pace').removeClass('pace-active').addClass('pace-inactive');
                    var blob = new Blob([result]);
                    if (window.navigator.msSaveOrOpenBlob)  // IE hack; see http://msdn.microsoft.com/en-us/library/ie/hh779016.aspx
                        window.navigator.msSaveBlob(blob, "test_report.csv");
                    else
                    {
                       var a = window.document.createElement("a");
                        a.href = window.URL.createObjectURL(blob, {type: "text/plain"});
                        a.download = "test_report.csv";
                        document.body.appendChild(a);
                        a.click();  // IE: "Access is denied"; see: https://connect.microsoft.com/IE/feedback/details/797361/ie-10-treats-blob-url-as-cross-origin-and-denies-access
                        document.body.removeChild(a);
                    }
                    $('.ajax-loader').hide();
               }
           })
       });

       $(".filter-field-user").each(function() {
          $( this ).select2({
            minimumInputLength: 1,
                    dropdownParent: $('#sendEmailModal'),
                multiple: true,
                  ajax: {
                      url: '/get-filter-fields-user',
                      dataType: "json",
                      data: function (params){
                  var query = {
                    search: params.term
                  }

                  // Query parameters will be ?search=[term]&type=public
                  return query;
                },
                processResults: function (data) {
                  // Tranforms the top-level key of the response object from 'items' to 'results'
                  return {
                    results: data
                  };
                },

                  }
            });
        });
      });

      $("#send-email-form").on('submit', function(e) {
        e.preventDefault();

        $('body').removeClass('pace-done').addClass('pace-running');
        $('.pace').removeClass('pace-inactive').addClass('pace-active');

        var form = $(this);
        var url = form.attr('action');

        $.ajax({
          type: "POST",
          url: url,
          data: form.serialize(),
          success: function(result) {
            $('#sendEmailModal').modal('hide');
            if (result.success) {
              $('#sync-success').show();
              var message = result.message;
              $('#sync-success span').html(message);
            } else {
              $('#sync-error').show();
              var message = result.message;
              $('#sync-error span').html(message);
            }

            $('body').removeClass('pace-running').addClass('pace-done');
            $('.pace').removeClass('pace-active').addClass('pace-inactive');

            $('.filter-field-user').val(null).trigger('change');
            form[0].reset();
          }
        });


      });

      $("#weekly_day").select2();


      $("#schedule-report-form").on('submit', function(e) {
        e.preventDefault();

        $('body').removeClass('pace-done').addClass('pace-running');
        $('.pace').removeClass('pace-inactive').addClass('pace-active');

        var form = $(this);
        var url = form.attr('action');

        $.ajax({
          type: "POST",
          url: url,
          data: form.serialize(),
          success: function(result) {
            $('#scheduleReportModal').modal('hide');
            if (result.success) {
              $('#sync-success').show();
              var message = result.message;
              $('#sync-success span').html(message);
            } else {
              $('#sync-error').show();
              var message = result.message;
              $('#sync-error span').html(message);
            }

            $('body').removeClass('pace-running').addClass('pace-done');
            $('.pace').removeClass('pace-active').addClass('pace-inactive');
          }
        });


      });

      $(".no-history").on('click', function(e){
            e.preventDefault();
            $('#sync-error').show();
            $('#sync-error span').html('No Asset Health Report Found');

            setTimeout(function() {
                $('#sync-error').hide();
            }, 5000); // 5000 milliseconds = 5 seconds
        });
</script>