<script src="/js/plugins/morris/raphael-2.1.0.min.js"></script>
<script src="/js/plugins/morris/morris.min.js"></script>
<script src="/js/plugins/chartJs/Chart.min.js"></script>
<script src="/js/plugins/match-height/jquery.matchHeight.min.js"></script>

<script type="text/javascript">
    var inputErrorCategoryId = $("#category-errors-id").val();
    var inputWarningCategoryId = $("#category-warnings-id").val();
    var inputNoticeCategoryId = $("#category-notices-id").val();
    var dateCache = "";
    //Line chart for error category
    $.ajax({
        url: "/assets-health-history-data",
        method: "POST",
        data: {
            "_token": "{{ csrf_token() }}",
            testId: null,
            categoryId: inputErrorCategoryId
        },
        dataType: "json", //parse the response data as JSON automatically
        success: function(data) {
            Morris.Area({
                element: 'asset-count-errors',
                data: data['graphData'],
                xkey: 'weekDate',
                ykeys: ['totalIssues'],
                labels: ['Total Issues'],
                parseTime: false,
                xLabelAngle: 60,
                smooth: false,
                resize: true,
                lineColors: ['red'],
                fillOpacity: 0.2,
                axes:"y",
                resize: true,
                redraw: true
            });
            $("div svg text").attr("style", "font-family: Roboto");
            $("div svg").attr("height", "400px");
        }
    });
    // Line chart for warning category
    $.ajax({
        url: "/assets-health-history-data",
        method: "POST",
        data: {
            "_token": "{{ csrf_token() }}",
            testId: null,
            categoryId: inputWarningCategoryId
        },
        dataType: "json", //parse the response data as JSON automatically
        success: function(data) {
            Morris.Area({
                element: 'asset-count-warnings',
                data: data['graphData'],
                xkey: 'weekDate',
                ykeys: ['totalIssues'],
                labels: ['Total Issues'],
                parseTime: false,
                xLabelAngle: 60,
                smooth: false,
                resize: true,
                lineColors: ['#ff4e0e'],
                fillOpacity: 0.2,
                axes:"y",
                resize: true,
                redraw: true
            });
            $("div svg text").attr("style", "font-family: Roboto");
            $("div svg").attr("height", "400px");
        }
    });
    // Line chart for notice category
    $.ajax({
        url: "/assets-health-history-data",
        method: "POST",
        data: {
            "_token": "{{ csrf_token() }}",
            testId: null,
            categoryId: inputNoticeCategoryId
        },
        dataType: "json", //parse the response data as JSON automatically
        success: function(data) {
            Morris.Area({
                element: 'asset-count-notices',
                data: data['graphData'],
                xkey: 'weekDate',
                ykeys: ['totalIssues'],
                labels: ['Total Issues'],
                parseTime: false,
                xLabelAngle: 60,
                smooth: false,
                resize: true,
                lineColors: ['#337ab7'],
                fillOpacity: 0.2,
                axes:"y",
                resize: true,
                redraw: true
            });
            $("div svg text").attr("style", "font-family: Roboto");
            $("div svg").attr("height", "400px");
        }
    });
    $(document).ready(function() {
        // Create the half donut chart
        @if (!empty($assetHealth))
            var ctx = document.getElementById('donutChart').getContext('2d');
            var myChart = new Chart(ctx, {
                type: 'doughnut',
                data: {!! json_encode($assetHealth) !!},
                options: {
                    cutoutPercentage: 50,  // Create a half donut
                    rotation: -Math.PI,     // Rotate to start from the top
                    circumference: Math.PI, // Show only half of the chart
                    responsive: true,
                    legend: {
                    display: false,
                    },
                    tooltips: {
                        enabled: false
                    }
                }
            });

            // Add a label in the center inside
            $('#centerLabel').text("{{ $assetHealth['datasets'][0]['data'][0] ?? 0 }}%");
        @endif

        @if (!empty($assetHistories))
        Morris.Area({
                element: 'asset-history-graph',
                data: {!! json_encode($assetHistories['datas']) !!},
                xkey: 'weekDate',
                ykeys: ['totalIssues'],
                labels: ['Total Issues'],
                parseTime: false,
                xLabelAngle: 60,
                smooth: false,
                resize: true,
                lineColors: ['#1ab394'],
                fillOpacity: 0.2,
                axes:"y"
            });
        @endif

        $('.match-height-block').matchHeight({ property: 'height' });
    });
</script>
