@extends('layouts.main')
@section('content')
@include('partials.breadcrumb', [
'breadcrumbTitle' => 'Health Reports',
'parentUrl' => '/asset-health',
'parentTitle' => 'Asset Health',
])
@include('assets-health.submenu')
<style type="text/css">
    .ibox-title {
        border-top: none !important;
    }

    .form-group,
    .table {
        text-align: left;
    }

    .ibox-tools a {
        color: #4d73be;
    }

    .passed-tests,
    .passed-tests a {
        color: #4CAF50;
        margin-bottom: 0;
    }

    .category-test-count .nav > li > a{
        color:#212427;
    }

    .category-test-count .nav > li.active > a{
        color:#fff;
    }

    .category-test-count .nav-pills > li + li {
        margin-left:5px;
    }

    tr.disabled a{
        /* Add your disabled styles here */
        opacity: 0.5;
        pointer-events: none!important;
    }
</style>


<div class="wrapper-content">
    <div class="container-fluid">
        {{-- @include('assets-health.reports-submenu') --}}

        <div class="ibox">
            <div class="ibox-content">
                <div class="row">
                    <div class="col-md-8 category-test-count">
                        <ul class="nav nav-pills">
                            <li role="presentation" class="active"><a class="category-filter" data-id="all" href="#">All <span id="total_count"></span></a></li>
                            @foreach ($allCategories as $category)
                            <li role="presentation"><a class="category-filter" data-id="{{ $category->slug }}"  href="#">{{ $category->category_name }} <span class="table_count" data-id="{{ $category->slug }}_table"></span></a></li>
                            @endforeach
                        </ul>
                    </div>
                    <div class="col-md-4">
                        <input type="text" id="searchField" class="form-control m-t-xs" placeholder="Search">
                    </div>
                </div>
            </div>
        </div>
        <div class="ibox">
            <div class="ibox-content">
                @foreach ($testReports as $categoryKey => $test)
                <div class="category-table" id="{{$categoryKey}}_table" @if ($categorySlug)
                style="display: none;"
                @endif>
                <div class="ibox-title">
                    <h5>{{ ucfirst($categoryKey) }}</h5>
                </div>
                <div class="ibox-content">
                    <table class="table searchable-table eq-table-col">
                        <thead>
                            <tr>
                                <th>Test</th>
                                <th># of Issues</th>
                                <th>Ignored Issues</th>
                                <th>Track Issue</th>
                            </tr>
                        </thead>
                        <tbody>
                            @forelse($test as $testCount)
                            <tr @if(!$testCount->status) class="disabled" @endif>
                                <td>
                                    <p class="{{ $testCount->test_count == 0 ? 'passed-tests' : 'normal-tests' }}">

                                        {{ $testCount->test_name }}
                                    </p>
                                </td>
                                <td><p class="{{ $testCount->test_count == 0 ? 'passed-tests' : '' }}">
                                    @if ($testCount->test_count == 0)
                                    {{ $testCount->test_count }}
                                    @else
                                    <a href="/asset-health-test-detail/{{ $testCount->id }}">
                                        {{ $testCount->test_count }}
                                    </a>
                                    @endif</p></td>
                                    <td>@php $ignoredCount = $testCount->ignoredDetails()->count() @endphp
                                        <p class="{{ $ignoredCount == 0 ? 'passed-tests' : '' }}">
                                            @if ($ignoredCount == 0)
                                            {{ $ignoredCount }}
                                            @else
                                            <a href="/asset-health-ignored-test-detail/{{ $testCount->id }}">
                                                {{ $ignoredCount }}
                                            </a>
                                            @endif</p>
                                        </td>
                                        <td>
                                            @if ($testCount->status)
                                            <label class="toggle-switch">
                                                <input type="checkbox" data-href="/disable-asset-health-test/{{ $testCount->test_id }}" class="toggleStatus" checked>
                                                <span class="toggle-slider"></span>
                                            </label>
                                            @else
                                            <label class="toggle-switch">
                                                <input type="checkbox" data-href="/enable-asset-health-test/{{ $testCount->test_id }}" class="toggleStatus">
                                                <span class="toggle-slider"></span>
                                            </label>
                                            @endif

                                        </td>
                                    </tr>
                                    @empty
                                    <tr>
                                        <td colspan="4">No Issues Found</td>
                                    </tr>
                                    @endforelse
                                </tbody>
                            </table>
                        </div>
                    </div>

                    @endforeach

                    <div class="no-results" style="display: none; text-align:center;">
                        <h2 style="
                        padding-top: 20px;
                        padding-bottom: 20px;">Nothing found</h2>
                        <p style="font-size: 16px;">We haven't found any checks matching your search.
                            Please modify your search criteria and try again.</p>
                        </div>
                    </div>

                </div>
            </div>
        </div>

        @stop
        @section('after_scripts')
        <script>
            @if ($categorySlug)
            var category = "{{$categorySlug}}";
            @else
            var category = "all";
            @endif
            var baseUrl = "{{url('/asset-health-reports')}}";
            $(document).ready(function(e){

                if(category == "all"){
                    updateCount();
                }

                if (category != "all") {
                    setTimeout(function() {
                        $(".category-filter[data-id='" + category + "']").trigger('click');
                    }, 500);
                }


                $(document).on('click', '.category-filter', function(e) {
                    e.preventDefault();
                    var categoryId = $(this).attr('data-id');

                    $(".category-table").hide();

                    if (categoryId == "all") {
                        $(".category-table").show();
                        updateURL('');
                    } else {
                        $("#"+categoryId+"_table").show();
                        updateURL(categoryId);
                    }

                    $('.category-test-count li').removeClass('active');
                    $(this).parent('li').addClass('active');

                    updateCount();
                });

                $('#searchField').on('keyup', function() {
                    var searchText = $(this).val().toLowerCase();

                    var activeTab = $(".category-test-count li.active").find('a').data('id');

                    if (activeTab == "all") {
                        $('.searchable-table').each(function() {
                            var table = $(this);
                            var found = false;
                            table.parents('.category-table').hide();

                            table.find('tbody tr').each(function() {
                                var row = $(this);
                                var testName = row.find('td:eq(0)').text().toLowerCase();

                                if (testName.includes(searchText)) {
                                    found = true;
                                    row.show();
                                } else {
                                    row.hide();
                                }
                            });

                            if (found) {
                                table.parents('.category-table').show();
                            }
                        });

                    } else {
                        $('.searchable-table').each(function() {
                            var table = $(this);
                            table.parents('.category-table').hide();

                            var table = $(this);
                            var found = false;

                            table.find('tbody tr').each(function() {
                                var row = $(this);
                                var testName = row.find('td:eq(0)').text().toLowerCase();

                                if (testName.includes(searchText)) {
                                    found = true;
                                    row.show();
                                } else {
                                    row.hide();
                                }
                            });

                            if (found && $(this).parents('.category-table').attr("id") == activeTab+"_table") {
                                table.parents('.category-table').show();
                            }
                        })
                    }


                    updateCount();
                });

                $('.toggleStatus').change(function() {
                    var href = $(this).attr('data-href');
                    if (!href) {
                        return;
                    }

                    // Dynamically create a form.
                    var form = $('<form>', {
                        method: 'POST',
                        action: href
                    });

                    form.append($('<input>', {
                        type: 'hidden',
                        name: '_token',
                        value: '{{ csrf_token() }}'
                    }));

                    // Append the form to the body and submit.
                    form.appendTo('body').submit();
                });

            });

            function updateURL(slug) {
                if (history.pushState) {
                    var newurl = baseUrl + '/' + slug;
                    window.history.pushState({path: newurl}, '', newurl);
                }
            }

            function updateCount() {
                var total = 0;
                var allTotal = 0;

                $(".no-results").hide();

                $('.table_count').each(function () {
                    var targetTableID = $(this).data('id');

                    var rowCount = $('#' + targetTableID + ' .normal-tests:visible').length;
                    var passedCount = $('#' + targetTableID + ' .passed-tests:visible').length;

                    if((rowCount+passedCount) == 0) {
                        $('#'+ targetTableID).hide();
                    } else {
                        $('#'+ targetTableID).show();
                    }

                    total+= rowCount;
                    allTotal += (rowCount+passedCount);



                    $(this).text("("+rowCount+")");

                });

                if (allTotal == 0) {
                    $(".no-results").show();
                }

                $("#total_count").html("(" +total+")");
            }
        </script>
        @stop
