<!doctype html>
<html lang="en">
  <head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Teqtivity Asset Health Report</title>
    <link href="{{ url('/css/print/bootstrap.min.css') }}" rel="stylesheet" integrity="sha384-T3c6CoIi6uLrA9TneNEoa7RxnatzjcDSCmG1MXxSR1GAsXEV/Dwwykc2MPK8M2HN" crossorigin="anonymous">
  </head>
  <body>
    <div class="row">
      <div class="col-md-12">
          <div class="pdf-page1" style=" display:block;text-align:center; position:   relative;
          top:        1cm;
          left:       1cm;
          width:      20cm;
          height:     36.5cm; ">
                <div class="header" style="height: 2cm;"></div>
                <div class="content text-center">
                      <div class="logo">
                        <img style="width: 300px;
                        height: 100px;margin-top:40%;" src="data:image/png;base64,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" />
                      </div>
                      <div class="report-title">
                          <h1 class="title" style="color:#212427;  margin-top:20%;">Asset Health Audit Report</h1>
                          <p style="color: #444;">{{ config('app.name') }}</p>
                      </div>
                </div>
                <div class="footer" style="position:absolute;
                bottom:     0;
                width:      100%;
                height:     1cm;vertical-align: bottom;">
                  <p style="text-align: center;">Generated on November 30, 2022 </span></p>
                </div>
          </div>
      </div>
    </div>
    <div class="row">
      <div class="col-md-12">
          <div class="pdf-page2" style=" display:block;text-align:center; position:   relative;
          top:        1cm;
          left:       1cm;
          width:      20cm;
          height:     34.5cm; ">
                <div class="header" style="height: 2cm;"></div>
                <div class="content">
                  <div class="row">
                      <div style="width:8cm;display:inline-block;float:left;">
                        <h3 style="margin-bottom:10px;font-size:20px;">Asset Health</h3>
                        <div id="donutChartContainer" style="position: relative; height: 5cm;">
                          <canvas id="donutChart"></canvas>
                          <div id="centerLabel" style="position: absolute; bottom: 5%; left: 45%; transform: translate(-50%, -50%); font-size: 40px;">{{ $assetHealth['datasets'][0]['data'][0] ?? 0 }}%</div>
                        </div>
                      </div>
                      <div style="width:12cm;display:inline-block;height:5cm;">hgghjghjghjghjgh
                        <div id="asset-history-graph"></div>
                      </div>
                  </div>
                </div>
                <div class="footer" style="position:   absolute;
    bottom:     0;
    width:      100%;
    height:     1cm;vertical-align: bottom;">
            <p style="display: inline-block;text-align:left;width:45%;">Generated on November 30, 2022</p>
            <p style="display: inline-block;text-align:left;width:50%;">The report data is taken from Teqtivity</p>
        </div>
    </div>
          </div>
      </div>
    </div>
    <script src="{{ url('/js/print/bootstrap.bundle.min.js') }}" integrity="sha384-C6RzsynM9kWDrMNeT87bh95OGNyZPhcTNXj1NW7RuBCsyN/o0jlpcV8Qyq46cDfL" crossorigin="anonymous"></script>
    <script src="{{ url('/js/plugins/morris/raphael-2.1.0.min.js')}}"></script>
    <script src="{{ url('/js/plugins/morris/morris.min.js')}}"></script>
    <script src="{{ url('/js/plugins/chartJs/Chart.min.js') }}"></script>

    <script>
      @if (!empty($assetHealth))
        var ctx = document.getElementById('donutChart').getContext('2d');
        var myChart = new Chart(ctx, {
            type: 'doughnut',
            data: {!! json_encode($assetHealth) !!},
            options: {
                cutoutPercentage: 50,  // Create a half donut
                rotation: -Math.PI,     // Rotate to start from the top
                circumference: Math.PI, // Show only half of the chart
                responsive: true,
                legend: {
                display: false,
                },
                tooltips: {
                    enabled: false
                }
            }
        });
      @endif

      @if (!empty($assetHistories))
        Morris.Area({
                element: 'asset-history-graph',
                data: {!! json_encode($assetHistories['datas']) !!},
                xkey: 'weekDate',
                ykeys: ['totalIssues'],
                labels: ['Total Issues'],
                parseTime: false,
                xLabelAngle: 60,
                smooth: false,
                resize: true,
                lineColors: ['#1ab394'],
                fillOpacity: 0.2,
                axes:"y"
            });
        @endif
    </script>
  </body>
</html>
