<style type="text/css">
    body,#top-content{
        background-color: #FFFFFF;
    }
    .ibox-title {
        border-top: none !important;
    }
    .form-group, .table {
        text-align: left;
    }
    .ibox-tools a {
        color: #4d73be;
    }
    .pdf-wrapper{
        margin:20px;
    }
    .testHistory,.categoryHistory{
        cursor: pointer;
    }   
    #first-content {
        min-height: 1600px;
        margin: auto;
        text-align: center;
        display: flex;
        justify-content: center;
        align-content: center;
        flex-direction: column;
    } 
    #first-content h1 {
        font-size: 80px;
    }
    .passed-tests, .passed-tests a {
        color: green;
    }
    .category-test-count-line p{
        font-size: 25px;
        margin-bottom: 25px;
    }
    .category-test-count-line .ibox-title {
        font-size: 27px;
    }
    .ibox-content.error {
        border-color: red;
    }
    .ibox-content.warning {
        border-color: #ff4e0e;
    }
    .ibox-content.notice {
        border-color: #337ab7;
    }
    .test-detail-graph{
        position: relative;
        text-align: center;
        margin: 100px auto;
    }
    .test-detail-graph img{
        width: 100%;
    }
    .cat-count-Error {
        color: red;
    }
    .cat-count-Warning {
        color: #ff4e0e;
    }
    .cat-count-Notice {
        color: #337ab7;
    }
        
</style>
<link href="/css/all.css" rel="stylesheet">
@if(!empty($assetHealth))
    <div class="pdf-wrapper row">
        <body>
            
            <div class="col-md-1"></div>
            <div class="wrapper-content col-md-11" id="top-content">
                <div class="container-fluid">
                    <div class="row">
                        <div id="first-content"><h1>Asset Health Report</h1></div>
                        <div class="col-lg-12">

                            <div class="ibox" >
                            
                            <div class="row category-test-count-line">
                                @if(!empty($assetHealth))
                                <div class="col-lg-6">
                                    <div class="ibox">
                                        <div class="ibox-title">
                                            Asset Health
                                        </div>
                                        <div class="ibox-content">
                                            <div id="morris-donut-chart"></div>
                                        </div>
                                    </div>
                                </div>
                                @endif
                                @if(!empty($scannedAssets))
                                <div class="col-lg-6">
                                    <div class="ibox">
                                        <div class="ibox-title">
                                            Scanned Assets
                                        </div>
                                        <div class="ibox-content">
                                            <div id="morris-donut-chart-scanned-assets"></div>
                                        </div>
                                    </div>
                                </div>
                                @endif
                            </div>

                                
                            </div>
                        </div>
                    </div>


                    <div class="row category-test-count-line">

                        <div class="ibox" >
                            @foreach($categories as  $category)
                            
                                <div class="col-md-4">
                                    <div class="ibox">
                                        <div class="ibox-title">           
                                        {{$category->category_name}}
                                        </div>
                                        <div class="ibox-content">                                            
                                            <a href="#">
                                                <h1 class="health-category-count cat-count-{{$category->category_name}}">{{$count[$category->category_name]}}</h1>
                                                
                                            </a>
                                            <input type="hidden" id="category-{{$category->slug}}-id" value="{{$category->id}}">
                                            <div class="row ">
                                                <div class="col-xs-12">
                                                    <div id="asset-count-{{$category->slug}}">
                                                    </div>                                                  
                                                    
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                            @endforeach

                            
                        </div>
                    </div>

                    
                    <div class="row category-test-count-line" style="min-height:420px;">
                        <div class="col-lg-12">

                            <div class="ibox" >
                            
                                <div class="ibox-title">Top Issues</div>   
                                <div class="ibox-content">
                                    @forelse($topIssues as $issues)
                                        <p>
                                            <a href="#">
                                            {{$issues->test_count}} Issues on {{$issues->assetHealthTest ? $issues->assetHealthTest->test_name : ""}}
                                            </a>
                                        </p>
                                        @empty
                                            <p>No Issues</p>
                                        @endforelse
                                </div>
                                
                            </div>

                            
                        </div>
                    </div>



                    <div class="row category-test-count-line">
                        @foreach($testReports as  $categoryKey=>$test)
                            <div class="ibox-title">
                                {{ucfirst($categoryKey)}}
                            </div>
                            <div class="ibox-content {{$categoryKey}}">
                                @foreach($test as  $testCount)
                                    <p class="{{$testCount->test_count == 0 ? 'passed-tests' : ''}}">
                                        @if($testCount->test_count == 0)
                                            {{$testCount->test_count}} issues with 
                                        @else
                                            <a href="#">
                                                {{$testCount->test_count}} issues with 
                                            </a>
                                        @endif
                                        {{$testCount->test_name}}
                                    </p>
                                @endforeach
                            </div>
                        @endforeach
                    </div>

                    <div class="row">
                        @foreach($testReports as  $categoryKey=>$test)
                            @foreach($test as $testCount)
                                @if($testCount->test_count != 0)
                                    <div class="ibox">
                                        <div class="ibox-title">
                                            <h1>{{$testCount->test_name}}</h1>
                                        </div>
                                        <div class="ibox-content">
                                            <div class="row">
                                                <div class="col-md-12 test-detail-graph">
                                                    <div id="test-graph-data-{{$testCount->id}}"></div>
                                                </div>
                                            </div>
                                            <div class="row">
                                            </div>
                                            <div class="row">
                                                <div class="table-responsive col-xs-12">
                                                    <table class="footable{{$testCount->id}} table table-stripped table-hover" >
                                                        <thead>
                                                            <tr>
                                                                <th>ID</th>
                                                                <th>Asset Type</th>
                                                                <th>Asset Tag #</th>
                                                                <th>Serial #</th>
                                                                <th>HW Standard</th>
                                                                <th>Tech Specs</th>
                                                                <th>User/Location</th>
                                                                <th>Date Added</th>
                                                            </tr>
                                                        </thead>
                                                        <tbody>
                                                            @if(array_key_exists($testCount->id,$testReportDetail))
                                                            @foreach($testReportDetail[$testCount->id] as $assets)
                                                            <tr>
                                                                <td>{{$loop->iteration}}</td>
                                                                <td>{{$assets->assetType ? $assets->assetType->name : ""}}</td>
                                                                <td>{{$assets->asset_tag}}</td>
                                                                <td>{{$assets->serial_no}}</td>
                                                                <td>{{$assets->makeAndModel ? $assets->makeAndModel->modelname : ""}}</td>
                                                                <td>{{$assets->technicalSpec ? $assets->technicalSpec->details : ''}}</td>
                                                                <td>{{$assets->user ? ($assets->user->first_name.$assets->user->last_name) : ($assets->location ?
        $assets->location->room_name : '')}}</td>
                                                                <td>{{$assets->created_at}}</td>
                                                            </tr>
                                                            @endforeach
                                                            @endif
                                                        </tbody>
                                                    </table>
                                                </div> 
                                            </div>

                                            
                                        </div>
                                    </div>
                                @endif
                            @endforeach
                        @endforeach
                    </div>



                </div>
            </div>
        </body>
    </div>
    @endif 



    <script type="text/javascript" src="/js/all.js"></script>




<script type="text/javascript" src="/js/plugins/morris/raphael-2.1.0.min.js"></script>
<script type="text/javascript" src="/js/plugins/morris/morris.min.js"></script>




<script src="/js/plugins/dataTables/datatables.min.js"></script>
<script src="/js/plugins/dataTables/dataTables.responsive.min.js"></script>
<link href="/css/plugins/dataTables/fixedHeader.dataTables.min.css" rel="stylesheet">
<link rel="stylesheet" href="/css/plugins/dataTables/responsive.dataTables.min.css">
<script type="text/javascript">   

    @if(!empty($assetHealth))
        Morris.Donut({
            element: 'morris-donut-chart',
            data: {!! json_encode($assetHealth) !!},
            resize: true,
            colors: ['#337ab7', '#f8ac59', '#1ab394', '#ed5565']
        });

        @foreach($categories as  $category)
                Morris.Area({
                    element: 'asset-count-{{$category->slug}}',
                    data: {!!json_encode($categoryGraph[$category->slug])!!} ,
                    xkey: 'weekDate',
                    ykeys: ['totalIssues'],
                    labels: ['Total Issues'],
                    parseTime: false,
                    xLabelAngle: 60,
                    smooth: false,
                    resize : true,
                    lineColors: {!!json_encode($graphColors[$category->slug])!!},
                    fillOpacity: 0.2,
                });
                //$("div svg text").attr("style", "font-family: Roboto");
                //$("div svg").attr("height", "400px");  
    @endforeach
    @endif
    @if(!empty($scannedAssets))
        Morris.Donut({
            element: 'morris-donut-chart-scanned-assets',
            data: {!! json_encode($scannedAssets) !!},
            resize: true,
            colors: ['#337ab7', '#f8ac59', '#1ab394', '#ed5565']
        });
    @endif  
   
   
    @if(!empty($assetHealth))
    @foreach($testReports as $categoryKey=>$test)
        @foreach($test as $testCount)
            @if($testCount->test_count != 0)

                $("#test-graph-data-{{$testCount->id}}").html("");
                Morris.Line({
                    element: 'test-graph-data-{{$testCount->id}}',
                    data: {!!json_encode($testDetailGraph[$testCount->id])!!} ,
                    xkey: 'weekDate',
                    ykeys: ['totalIssues'],
                    labels: ['Total Issues'],
                    parseTime: false,
                    xLabelAngle: 60,
                    smooth: false,
                    resize : true,
                    fillOpacity: 0.2,
                });                  
            @endif
        @endforeach
    @endforeach
    @endif      

</script>