@extends('layouts.main')
@section('content')
@include('partials.breadcrumb', ['breadcrumbTitle' => $data->assetHealthTest ? $data->assetHealthTest->test_name."" : "", 'parentUrl' => '/asset-health', 'parentTitle' => 'Asset Health'])
@include('assets-health.submenu')
<style type="text/css">
    .ibox-title {
        border-top: none !important;
    }
    .form-group, .table {
        text-align: left;
    }
    .ibox-tools a {
        color: #4d73be;
    }
</style>

<div class="wrapper-content">
    <div class="container-fluid">
        <!-- Cost Analysis graph - full page width  - Start -->
        <div class="row">
            <div class="col-lg-12">

                <div class="ibox" >
                    <div class="ibox-title">
                        <h5 style="margin-bottom:20px;"> <span id="test_detail_count">{{$data->ignored_details_count}}</span>&nbsp;Ignored From {{$data->assetHealthTest ? $data->assetHealthTest->test_name : ""}}</h5>
                        <input type="hidden" id="asset_health_report_id" value="{{$data->id}}">
                        <div class="ibox-tools" style="clear: both;">
                            <a href="/asset-health-test-detail/{{ $data->id }}" id="create-ticket" class="btn btn-primary pull-left">Back to Test Detail</a>
                        </div>
                    </div>

                    <div class="ibox-content">
                        @include('partials.success')
                        @include('partials.error-message')
                        <div class="ajax-loader"><img src="/img/ajax-loader.gif"></div>
                        {{-- <div class="ibox-title">
                            <div class="ibox-tools">
                                <a href="#" data-id='' data-toggle='modal' data-target='#how_to_fix_modal'>Why and How to Fix</a>
                            </div>
                        </div> --}}
                        <div class="table-responsive">
                            <table class="ignored-footable table table-stripped table-hover" data-page-size="50" data-filter=#filter>
                                <thead>
                                    <tr>
                                        @foreach(config('asset-health.datatable_columns')[$data->assetHealthTest->slug ?? 'default'] as $key => $label)
                                            <th>{{ $label }}</th>
                                        @endforeach
                                        <th>Mark as Ignored</th>
									</tr>
                                </thead>
                                <tbody>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

@stop
@section('after_scripts')
@include('assets-health.scripts.test-detail')
@include('assets-health.modals.how-to-fix')
@stop
