@extends('layouts.main')
@section('content')
@include('partials.breadcrumb', ['breadcrumbTitle' => 'Health History', 'parentUrl' => '/asset-health',
'parentTitle' => 'Asset Health'])
@include('assets-health.submenu')
<style>
    .testHistory,.categoryHistory{
        cursor: pointer;
        margin-bottom: 5px;
        display: inline-block;
    }

    .legend {
        display: none;
        margin-left:5px;
        margin-bottom:5px;
    }

    .legend.show {
        display: inline-block!important;
    }

    .testHistory, .categoryHistory, .legend {
        border-color: #a9abb6;
        color: #212427;
        border-radius: 50px;
        padding:5px 10px;
    }
    .testHistory:hover, .categoryHistory:hover, .legend:hover {
        background:#f4f5f9;
        border-color: #a9abb6;
        color: #212427!important;
    }

    .testHistory.active, .categoryHistory.active, .legend.active {
        background-color:#f2f9ff;
        border-color: #0da5f9;
        color: #0da5f9 !important;
        box-shadow:none!important;
    }

    .testHistory.active:hover, .categoryHistory.active:hover, .legend.active:hover {
        background-color:#c4e5fe;
        border-color: #0da5f9;
        color: #0da5f9 !important;
        box-shadow:none!important;
    }

    .general_hr, .errors_hr, .warnings_hr, .notices_hr {
        border-bottom: 5px solid;
    }

    .general_hr {
        border-color: #a9abb6;
    }

    .errors_hr {
        border-color: #ff4953 !important;
    }

    .warnings_hr {
        border-color: #ff8c43 !important;
    }

    .notices_hr {
        border-color: #2bb3ff !important;
    }

    .morris-hover {
        background-color: #F7F7F7 !important; /* Background color of the tooltip */
        border-color: rgba(219, 219, 219, 0.25) !important; /* Border color of the tooltip */
        color: #333 !important; /* Text color of the tooltip */
        box-shadow: 0px 0px 11px 0px rgba(219, 219, 219, 0.25);
    }

    /* 
    .morris-hover-row-label {
        color: #333 !important;  Text color of the row label in the tooltip
    } 
    */

    .morris-hover-point {
        /* color: #333 !important; Text color of the point label in the tooltip */
        text-align: left;
        font-weight:500;
    }

    .morris-hover-point span{
        display: inline-block;
        border-radius: 50%;
        width: 8px;
        height: 8px;
        text-align: center;
    }

    .categoryHistory span, .testHistory span, .legend span:first-child {
        display: inline-block;
        border-radius: 50%;
        width: 12px;
        height: 12px;
        text-align: center;
        border:2px solid #8a8e9b;
    }
    .button-with-close {
        position: relative;
        padding-right: 35px; /* Adjust the padding to accommodate the close icon */
    }

    .close-icon {
        position: absolute;
        top: 50%;
        right: 10px; /* Adjust the right spacing */
        transform: translateY(-50%);
        cursor: pointer;
        font-size: 20px;
        font-weight: 600;
    }
</style>
<div class="wrapper-content">
    <div class="container-fluid">
        <div class="ibox">
            <div class="ibox-content">
                <div class="row">
                    <div class="col-md-4 divHeight">
                        <div class="form-group">
                            <label class="control-label">Date Range</label>
                            <div class="form-group data_1">
                                <div class="input-group date">
                                    <span class="input-group-addon"><i class="icon icon-calendar-2"></i></span><input
                                    type="text" name="date_from" class="form-control readonly-white active-user-filter" id="date_from" value=""
                                    placeholder="From" autocomplete="off" readonly>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="col-md-4 divHeight">
                        <div class="form-group">
                            <label class="control-label">&nbsp;</label>
                            <div class="form-group data_1">
                                <div class="input-group date">
                                    <span class="input-group-addon"><i class="icon icon-calendar-2"></i></span><input
                                    type="text" class="form-control readonly-white active-user-filter" value="" placeholder="To" name="date_to"
                                    id="date_to" autocomplete="off" readonly>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="ibox">

            <div class="ibox-content">
                <form action="{{route('assets-health-history-data')}}" method="post" id="assets-health-history-form">
                    {{csrf_field()}}
                    <div class="row">
                        <div class="col-sm-6">
                            <div class="col-sm-6">
                                <div class="form-group"></div>
                            </div>
                        </div>
                    </div>
                </form>
                <div class="row ">
                    <div class="col-xs-12">
                        <div id="weekly-assets-issues" style="height:400px;"></div>
                        <h4 style="margin-top:20px;">Legend</h4>

                        <a class="legend btn btn-default button-with-close" data-legend="all" data-id="all"><span data-background="{{ config
                            ('asset-health.map_colors')['all'] }}"></span> Total Issues <span class="close-icon" aria-hidden="true">&times;</span></a>
                            @foreach($getAllCategories as $categories)
                            <a href="#" class="legend btn btn-default button-with-close" data-legend="category" data-id="{{$categories->id}}"><span data-background="{{ config
                                ('asset-health.map_colors')[$categories->slug] }}"></span> Total {{$categories->category_name}} <span class="close-icon" aria-hidden="true">&times;</span></a>
                                @endforeach
                                @foreach($getAllCategories as $categories)
                                @foreach($categories->assetHealthTests as $tests)
                                <a class="legend btn btn-default button-with-close" data-legend="test" data-id="{{$tests->id}}"><span data-background ="{{ config
                                    ('asset-health.map_colors')[$tests->slug] }}"></span> {{$tests->test_name}} <span class="close-icon" aria-hidden="true">&times;</span></a>
                                    @endforeach
                                    @endforeach
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="ibox">
                        <div class="ibox-content">
                            <div class="row history-category-tests">
                                <div class="col-md-3">
                                    <h4>General</h4>
                                    <hr class="general_hr">
                                    <a class="history categoryHistory btn btn-default clear active" data-id="all" data-legend="all"><span data-background="{{ config
                                        ('asset-health.map_colors')['all'] }}"></span> Total Issues</a>
                                        @foreach($getAllCategories as $categories)
                                        <a href="#" class="history categoryHistory btn btn-default clear" data-legend="category" data-id="{{$categories->id}}"><span data-background="{{ config
                                            ('asset-health.map_colors')[$categories->slug] }}"></span> Total {{$categories->category_name}}</a>
                                            @endforeach
                                        </div>
                                        @foreach($getAllCategories as $categories)

                                        <div class="col-md-3">
                                            <h4 class="cat-count-{{$categories->category_name}}" id="category_{{$categories->id}}">{{$categories->category_name}}</h4>
                                            <hr class="{{ $categories->slug }}_hr">
                                            @foreach($categories->assetHealthTests as $tests)
                                            <a class="history testHistory btn btn-default clear" data-legend="test" data-id="{{$tests->id}}"><span data-background ="{{ config
                                                ('asset-health.map_colors')[$tests->slug] }}"></span> {{$tests->test_name}}</a>
                                                @endforeach
                                            </div>
                                            @endforeach
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>


                        @stop
                        @section('after_scripts')
                        @include('assets-health.scripts.assets-health-history')
                        @stop